/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.pace.model.Person;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommonDNetXsltFunctions
extends AbstractDNetXsltFunctions {
    private static final int MAX_COAUTHORS = 50;

    public static String personResult_Authorship(String source, String target, int rank, String relClass, String provenanceAction, String trust, NodeList about) {
        HashMap params = Maps.newHashMap();
        params.put("rank", "" + rank);
        return CommonDNetXsltFunctions.rel(source, target, RelTypeProtos.RelType.personResult.name(), RelTypeProtos.SubRelType.authorship.name(), relClass, provenanceAction, trust, about, params);
    }

    public static String rel(String source, String target, String relType, String subRelType, String relClass, String provenanceAction, String trust) {
        return CommonDNetXsltFunctions.rel(source, target, relType, subRelType, relClass, provenanceAction, trust, null, null);
    }

    public static String rel(String source, String target, String relType, String subRelType, String relClass, String provenanceAction, String trust, NodeList about) {
        return CommonDNetXsltFunctions.rel(source, target, relType, subRelType, relClass, provenanceAction, trust, about, null);
    }

    public static String rel(String source, String target, String relType, String subRelType, String relClass, String provenanceAction, String trust, NodeList about, Map<String, String> params) {
        try {
            String eSource = OafRowKeyDecoder.decode(source).getKey();
            String eTarget = OafRowKeyDecoder.decode(target).getKey();
            RelTypeProtos.RelType rType = RelTypeProtos.RelType.valueOf((String)relType);
            RelTypeProtos.SubRelType srType = RelTypeProtos.SubRelType.valueOf((String)subRelType);
            RelMetadataProtos.RelMetadata.Builder metadata = RelMetadataProtos.RelMetadata.newBuilder().setSemantics(CommonDNetXsltFunctions.getSimpleQualifier(relClass, CommonDNetXsltFunctions.getVocabularyName(rType)));
            Message.Builder subRel = CommonDNetXsltFunctions.getSubRelBuilder(metadata, srType, params);
            OafProtos.OafRel.Builder rel = CommonDNetXsltFunctions.getRelBuilder(rType, srType, CommonDNetXsltFunctions.getRel(eSource, eTarget, rType, srType, relClass, false), subRel);
            OafProtos.Oaf oaf = CommonDNetXsltFunctions.getOaf(rel, CommonDNetXsltFunctions.getDataInfo(about, provenanceAction, trust, false, false));
            return CommonDNetXsltFunctions.base64(oaf.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    public static String person(String personId, NodeList about, String provenanceAction, String trust, String collectedFromId, String collectedFromName, String originalId, String dateOfCollection, String fullname) {
        return CommonDNetXsltFunctions.person(personId, fullname, null, null, null, provenanceAction, trust, about, collectedFromId, collectedFromName, originalId, dateOfCollection);
    }

    public static String person(String personId, String fullname, NodeList authors, String namespaceprefix, String objIdentifier, String provenanceAction, String trust, NodeList about, String collectedFromId, String collectedFromName, String originalId, String dateOfCollection) {
        try {
            String entityId = OafRowKeyDecoder.decode(personId).getKey();
            PersonProtos.Person.Builder person = PersonProtos.Person.newBuilder();
            PersonProtos.Person.Metadata.Builder metadata = CommonDNetXsltFunctions.getMetadata(fullname);
            if (authors != null) {
                for (int i = 0; i < authors.getLength() && i < 50; ++i) {
                    Node node = authors.item(i);
                    String name = StringUtils.trim((String)node.getTextContent());
                    if (name.equals(fullname)) continue;
                    PersonProtos.Person.CoAuthor.Builder coAuthor = PersonProtos.Person.CoAuthor.newBuilder();
                    coAuthor.setId(CommonDNetXsltFunctions.oafId("person", namespaceprefix, objIdentifier + "::" + name));
                    coAuthor.setMetadata(CommonDNetXsltFunctions.getMetadata(name));
                    person.addCoauthor(coAuthor);
                }
            }
            ArrayList pids = Lists.newArrayList((Object[])new FieldTypeProtos.StructuredProperty[]{CommonDNetXsltFunctions.getStructuredProperty(originalId, "oai", "oai", "dnet:pid_types", "dnet:pid_types")});
            OafProtos.OafEntity.Builder entity = CommonDNetXsltFunctions.getEntity(TypeProtos.Type.person, entityId, CommonDNetXsltFunctions.getKV(collectedFromId, collectedFromName), Lists.newArrayList((Object[])new String[]{originalId}), dateOfCollection, pids).setPerson(person.setMetadata(metadata));
            OafProtos.Oaf oaf = CommonDNetXsltFunctions.getOaf(entity, CommonDNetXsltFunctions.getDataInfo(about, provenanceAction, trust, false, false));
            return CommonDNetXsltFunctions.base64(oaf.toByteArray());
        }
        catch (Throwable e) {
            System.err.println("personId: " + personId);
            System.err.println("fullname: " + fullname);
            System.err.println("provenanceAction: " + provenanceAction);
            System.err.println("trust: " + trust);
            System.err.println("collectedFromId: " + collectedFromId);
            System.err.println("collectedFromName: " + collectedFromName);
            System.err.println("originalId: " + originalId);
            System.err.println("dateOfCollection: " + dateOfCollection);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static PersonProtos.Person.Metadata.Builder getMetadata(String fullname) {
        PersonProtos.Person.Metadata.Builder metadata = PersonProtos.Person.Metadata.newBuilder();
        metadata.setFullname(CommonDNetXsltFunctions.sf(fullname));
        Person p = new Person(fullname, false);
        if (p.isAccurate()) {
            metadata.setFirstname(CommonDNetXsltFunctions.sf(p.getNormalisedFirstName()));
            metadata.clearSecondnames().addSecondnames(CommonDNetXsltFunctions.sf(p.getNormalisedSurname()));
        }
        return metadata;
    }
}

