package eu.dnetlib.data.transform.xml;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos.StructuredProperty;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.ResultProtos.Result;
import eu.dnetlib.data.proto.ResultProtos.Result.Instance;
import eu.dnetlib.data.proto.TypeProtos.Type;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdfToHbaseXsltFunctions extends CommonDNetXsltFunctions {

	private static Map<String, String> mappingAccess = Maps.newHashMap();

	static {

		mappingAccess.put("info:eu-repo/semantics/openAccess", "OPEN");
		mappingAccess.put("info:eu-repo/semantics/closedAccess", "CLOSED");
		mappingAccess.put("info:eu-repo/semantics/restrictedAccess", "RESTRICTED");
		mappingAccess.put("info:eu-repo/semantics/embargoedAccess", "EMBARGO");

		// Transformator now maps the access rights into proper values, not sure if it does for all datasets.
		mappingAccess.put("OPEN", "OPEN");
		mappingAccess.put("CLOSED", "CLOSED");
		mappingAccess.put("RESTRICTED", "RESTRICTED");
		mappingAccess.put("EMBARGO", "EMBARGO");

	}

	public static String odfResult(
			final String resultId,
			final NodeList about,
			final NodeList metadata,
			final NodeList titles,
			final NodeList subjects,
			final NodeList publisher,
			final NodeList descriptions,
			final NodeList dates,
			final NodeList dateaccepted,
			final NodeList resourceTypes,
			final NodeList formats,
			final NodeList sizes,
			final NodeList languages,
			final NodeList cobjcategory,
			final NodeList rights,
			final NodeList version,
			final NodeList pidList,
			final String provenance,
			final String trust,
			final String hostedbyId,
			final String hostedbyName,
			final String collectedfromId,
			final String collectedfromName,
			final NodeList originalIds,
			final String instanceUri,
			final String dateOfCollection) {

		try {
			final String entityId = OafRowKeyDecoder.decode(resultId).getKey();

			final Result.Builder result = Result.newBuilder();
			Result.Metadata.Builder metadataProto = Result.Metadata.newBuilder();

			// subject
			for (int i = 0; i < subjects.getLength(); i++) {
				Node currentNode = subjects.item(i);
				NodeList childNodes = currentNode.getChildNodes();
				if (childNodes.getLength() > 0) {
					String subjectValue = childNodes.item(0).getNodeValue();
					addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("subject"),
							getStructuredProperty(subjectValue, "keyword", "keyword", "dnet:result_subject", "dnet:result_subject"));
				}
			}

			// title
			for (int i = 0; i < titles.getLength(); i++) {
				Node currentNode = titles.item(i);
				NodeList childNodes = currentNode.getChildNodes();
				if (childNodes.getLength() > 0) {
					String titleValue = childNodes.item(0).getNodeValue();
					String classname = "main title";
					String classid = "main title";
					if (currentNode.hasAttributes()) {
						NamedNodeMap attributes = currentNode.getAttributes();
						Node titleType = attributes.getNamedItem("titleType");

						if (titleType != null && titleType.getNodeValue().equals("AlternativeTitle")) {
							classname = "alternative title";
							classid = "alternative title";
						}
						if (titleType != null && titleType.getNodeValue().equals("Subtitle")) {
							classname = "subtitle";
							classid = "subtitle";
						}
						if (titleType != null && titleType.getNodeValue().equals("TranslatedTitle")) {
							classname = "translated title";
							classid = "translated title";
						}
					}
					addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("title"),
							getStructuredProperty(titleValue, classname, classid, "dnet:dataCite_title", "dnet:dataCite_title"));
				}
			}

			// description
			for (int i = 0; i < descriptions.getLength(); i++) {
				Node currentNode = descriptions.item(i);
				if (currentNode != null && currentNode.hasChildNodes()) {
					String descriptionValue = currentNode.getChildNodes().item(0).getNodeValue();
					addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("description"), descriptionValue);
				}
			}

			// publisher
			addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("publisher"), getFirstItem(publisher));

			// dates
			for (int i = 0; i < dates.getLength(); i++) {
				Node currentNode = dates.item(i);
				if (currentNode != null && currentNode.hasAttributes() && currentNode.hasChildNodes()) {
					String dateAttribute = currentNode.getAttributes().getNamedItem("dateType").getNodeValue();
					String dateValue = currentNode.getChildNodes().item(0).getNodeValue();
					String protoAttribute = "relevantdate";
					if ("Accepted".equals(dateAttribute)) {
						protoAttribute = "dateofacceptance";
					} else if ("Issued".equals(dateAttribute)) {
						protoAttribute = "storagedate";
					} else if ("Updated".equals(dateAttribute)) {
						protoAttribute = "lastmetadataupdate";
					} else if ("Available".equals(dateAttribute)) {
						protoAttribute = "embargoenddate";
					}
					if (protoAttribute.equals("relevantdate") == false) {
						addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName(protoAttribute), dateValue);
					} else {
						addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName(protoAttribute),
								getStructuredProperty(dateValue, "UNKNOWN", "UNKNOWN", "dnet:dataCite_date", "dnet:dataCite_date"));
					}
				}
			}

			// dateofacceptance
			addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("dateofacceptance"), getFirstItem(dateaccepted));

			// size
			addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("size"), getFirstItem(sizes));

			// format
			addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("format"), getFirstItem(formats));

			// version
			addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("version"), getFirstItem(version));

			// language
			addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("language"),
					setQualifier(getDefaultQualifier("dnet:languages"), Lists.newArrayList(getFirstItem(languages))));

			// resultType
			addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("resulttype"), getSimpleQualifier("dataset", "dnet:result_typologies"));

			String tmpID;
			String TmpName;

			if (hostedbyId == null && hostedbyName == null) {
				tmpID = collectedfromId;
				TmpName = collectedfromName;
			} else {
				tmpID = hostedbyId;
				TmpName = hostedbyName;
			}

			final Instance.Builder instance = Instance.newBuilder().setHostedby(getKV(tmpID, TmpName));

			String tmpRigths = "UNKNOWN";
			final String firstRight = getFirstItem(rights);
			if (mappingAccess.containsKey(firstRight)) {
				tmpRigths = mappingAccess.get(firstRight);
			}

			addField(instance, Instance.getDescriptor().findFieldByName("licence"),
					setQualifier(getDefaultQualifier("dnet:access_modes"), Lists.newArrayList(tmpRigths)));

			addField(instance, Instance.getDescriptor().findFieldByName("instancetype"),
					setQualifier(getDefaultQualifier("dnet:dataCite_resource"), Lists.newArrayList(getFirstItem(cobjcategory))));

			addField(instance, Instance.getDescriptor().findFieldByName("url"), instanceUri);

			result.addInstance(instance);

			List<StructuredProperty> pids = parsePids(pidList);

			// original ids
			final List<String> originalIdList = Lists.newArrayList();
			for (int i = 0; i < originalIds.getLength(); i++) {
				Node currentNode = originalIds.item(i);
				if (currentNode != null && currentNode.hasChildNodes()) {
					originalIdList.add(currentNode.getChildNodes().item(0).getNodeValue());
				}
			}

			OafEntity.Builder entity =
					getEntity(Type.result, entityId, getKV(collectedfromId, collectedfromName), originalIdList, dateOfCollection, pids).setResult(
							result.setMetadata(metadataProto));

			entity.setOaiprovenance(getOAIProvenance(about));

			Oaf oaf = getOaf(entity, getDataInfo(about, provenance, trust, false, false));
			return base64(oaf.toByteArray());
		} catch (Exception e) {
			e.printStackTrace(System.err);
			throw new RuntimeException(e);
		}

	}

	public static String getFirstItem(final NodeList list) {
		String out = "";
		if (list != null) {

			if (list.getLength() > 0 && list.item(0).getChildNodes() != null && list.item(0).getChildNodes().getLength() > 0) {
				out = list.item(0).getChildNodes().item(0).getNodeValue();
			}
		}
		return out;
	}

}
