package eu.dnetlib.data.mapreduce.util;

import java.util.List;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors.FieldDescriptor;
import com.google.protobuf.GeneratedMessage;

import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.TypeProtos.Type;
import eu.dnetlib.data.transform.AbstractProtoMapper;

public class OafEntityDecoder extends AbstractProtoMapper {

	private final OafEntity oafEntity;

	public static OafEntityDecoder decode(final OafEntity oafEntity) {
		return new OafEntityDecoder(oafEntity);
	}

	private OafEntityDecoder(final OafEntity oafEntity) {
		this.oafEntity = oafEntity;
	}

	public Type getType() {
		return oafEntity.getType();
	}

	public String getId() {
		return oafEntity.getId();
	}

	public GeneratedMessage getOafEntity() {
		return oafEntity;
	}

	public GeneratedMessage getEntity() {
		final FieldDescriptor fd = oafEntity.getDescriptorForType().findFieldByName(typeName());
		return (GeneratedMessage) oafEntity.getField(fd);
	}

	public String typeName() {
		return oafEntity.getType().toString();
	}

	public GeneratedMessage getMetadata() {
		final GeneratedMessage entity = getEntity();
		final FieldDescriptor fd = entity.getDescriptorForType().findFieldByName("metadata");
		final GeneratedMessage field = (GeneratedMessage) entity.getField(fd);
		return field;
	}

	public List<String> getFieldValues(final String path) {
		return Lists.newLinkedList(Iterables.transform(processPath(getOafEntity(), path, eu.dnetlib.pace.config.Type.String), new Function<Object, String>() {

			@Override
			public String apply(final Object o) {
				return o.toString();
			}
		}));
	}

	public String getDateOfCollection() {
		return oafEntity.getDateofcollection();
	}
}
