/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.PersonResultProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultProjectProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.ResultResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetOafXsltFunctions;
import eu.dnetlib.pace.model.Person;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataciteToHbaseXsltFunctions
extends AbstractDNetOafXsltFunctions {
    private static Map<String, String> mappingAccess = Maps.newHashMap();

    public static String oafResult_FromDatacite(String resultId, NodeList dataInfo, NodeList metadata, NodeList titles, NodeList subjects, NodeList publisher, NodeList descriptions, NodeList dates, NodeList dateaccepted, NodeList resourceTypes, NodeList formats, NodeList sizes, NodeList languages, NodeList cobjcategory, NodeList rights, NodeList version, NodeList pidList, String provenance, String trust, String hostedbyId, String hostedbyName, String collectedfromId, String collectedfromName, NodeList originalIds, String instanceUri, String dateOfCollection) {
        try {
            String TmpName;
            String tmpID;
            NodeList childNodes;
            Node currentNode;
            int i;
            String entityId = OafRowKeyDecoder.decode(resultId).getKey();
            ResultProtos.Result.Builder result = ResultProtos.Result.newBuilder();
            ResultProtos.Result.Metadata.Builder metadataProto = ResultProtos.Result.Metadata.newBuilder();
            for (i = 0; i < subjects.getLength(); ++i) {
                currentNode = subjects.item(i);
                childNodes = currentNode.getChildNodes();
                if (childNodes.getLength() <= 0) continue;
                String subjectValue = childNodes.item(0).getNodeValue();
                DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("subject"), DataciteToHbaseXsltFunctions.getStructuredProperty(subjectValue, "keyword", "keyword", "dnet:result_subject", "dnet:result_subject"));
            }
            for (i = 0; i < titles.getLength(); ++i) {
                currentNode = titles.item(i);
                childNodes = currentNode.getChildNodes();
                if (childNodes.getLength() <= 0) continue;
                String titleValue = childNodes.item(0).getNodeValue();
                String classname = "main title";
                String classid = "main title";
                if (currentNode.hasAttributes()) {
                    NamedNodeMap attributes = currentNode.getAttributes();
                    Node titleType = attributes.getNamedItem("titleType");
                    if (titleType != null && titleType.getNodeValue().equals("AlternativeTitle")) {
                        classname = "alternative title";
                        classid = "alternative title";
                    }
                    if (titleType != null && titleType.getNodeValue().equals("Subtitle")) {
                        classname = "subtitle";
                        classid = "subtitle";
                    }
                    if (titleType != null && titleType.getNodeValue().equals("TranslatedTitle")) {
                        classname = "translated title";
                        classid = "translated title";
                    }
                }
                DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("title"), DataciteToHbaseXsltFunctions.getStructuredProperty(titleValue, classname, classid, "dnet:dataCite_title", "dnet:dataCite_title"));
            }
            for (i = 0; i < descriptions.getLength(); ++i) {
                currentNode = descriptions.item(i);
                if (currentNode == null || !currentNode.hasChildNodes()) continue;
                String descriptionValue = currentNode.getChildNodes().item(0).getNodeValue();
                DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("description"), descriptionValue);
            }
            DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("publisher"), DataciteToHbaseXsltFunctions.getFirstItem(publisher));
            for (i = 0; i < dates.getLength(); ++i) {
                currentNode = dates.item(i);
                if (currentNode == null || !currentNode.hasAttributes() || !currentNode.hasChildNodes()) continue;
                String dateAttribute = currentNode.getAttributes().getNamedItem("dateType").getNodeValue();
                String dateValue = currentNode.getChildNodes().item(0).getNodeValue();
                String protoAttribute = "relevantdate";
                if ("Accepted".equals(dateAttribute)) {
                    protoAttribute = "dateofacceptance";
                } else if ("Issued".equals(dateAttribute)) {
                    protoAttribute = "storagedate";
                } else if ("Updated".equals(dateAttribute)) {
                    protoAttribute = "lastmetadataupdate";
                } else if ("Available".equals(dateAttribute)) {
                    protoAttribute = "embargoenddate";
                }
                if (!protoAttribute.equals("relevantdate")) {
                    DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName(protoAttribute), dateValue);
                    continue;
                }
                DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName(protoAttribute), DataciteToHbaseXsltFunctions.getStructuredProperty(dateValue, "UNKNOWN", "UNKNOWN", "dnet:dataCite_date", "dnet:dataCite_date"));
            }
            DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("dateofacceptance"), DataciteToHbaseXsltFunctions.getFirstItem(dateaccepted));
            DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("size"), DataciteToHbaseXsltFunctions.getFirstItem(sizes));
            DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("format"), DataciteToHbaseXsltFunctions.getFirstItem(formats));
            DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("version"), DataciteToHbaseXsltFunctions.getFirstItem(version));
            DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("language"), DataciteToHbaseXsltFunctions.setQualifier(DataciteToHbaseXsltFunctions.getDefaultQualifier("dnet:languages"), Lists.newArrayList((Object[])new String[]{DataciteToHbaseXsltFunctions.getFirstItem(languages)})));
            DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("resulttype"), DataciteToHbaseXsltFunctions.getSimpleQualifier("dataset", "dnet:result_typologies"));
            if (hostedbyId == null && hostedbyName == null) {
                tmpID = collectedfromId;
                TmpName = collectedfromName;
            } else {
                tmpID = hostedbyId;
                TmpName = hostedbyName;
            }
            ResultProtos.Result.Instance.Builder instance = ResultProtos.Result.Instance.newBuilder().setHostedby(DataciteToHbaseXsltFunctions.getKV(tmpID, TmpName));
            String tmpRigths = "UNKNOWN";
            String firstRight = DataciteToHbaseXsltFunctions.getFirstItem(rights);
            if (mappingAccess.containsKey(firstRight)) {
                tmpRigths = mappingAccess.get(firstRight);
            }
            DataciteToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("licence"), DataciteToHbaseXsltFunctions.setQualifier(DataciteToHbaseXsltFunctions.getDefaultQualifier("dnet:access_modes"), Lists.newArrayList((Object[])new String[]{tmpRigths})));
            DataciteToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("instancetype"), DataciteToHbaseXsltFunctions.setQualifier(DataciteToHbaseXsltFunctions.getDefaultQualifier("dnet:dataCite_resource"), Lists.newArrayList((Object[])new String[]{DataciteToHbaseXsltFunctions.getFirstItem(cobjcategory)})));
            DataciteToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("url"), instanceUri);
            result.addInstance(instance);
            List<FieldTypeProtos.StructuredProperty> pids = DataciteToHbaseXsltFunctions.parsePids(pidList);
            ArrayList originalIdList = Lists.newArrayList();
            for (int i2 = 0; i2 < originalIds.getLength(); ++i2) {
                Node currentNode2 = originalIds.item(i2);
                if (currentNode2 == null || !currentNode2.hasChildNodes()) continue;
                originalIdList.add(currentNode2.getChildNodes().item(0).getNodeValue());
            }
            OafProtos.OafEntity.Builder entity = DataciteToHbaseXsltFunctions.getEntity(TypeProtos.Type.result, entityId, DataciteToHbaseXsltFunctions.getKV(collectedfromId, collectedfromName), originalIdList, dateOfCollection, pids).setResult(result.setMetadata(metadataProto));
            OafProtos.Oaf oaf = DataciteToHbaseXsltFunctions.getOaf(entity, DataciteToHbaseXsltFunctions.getDataInfo(dataInfo, provenance, trust, false, false));
            return DataciteToHbaseXsltFunctions.base64(oaf.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    public static String oafResultResult_PublicationDataset_FromDatacite(String source, String target, String relClass, String provenanceAction, String trust, NodeList dataInfo) {
        try {
            String eSource = OafRowKeyDecoder.decode(source).getKey();
            String eTarget = OafRowKeyDecoder.decode(target).getKey();
            RelMetadataProtos.RelMetadata.Builder metadata = RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DataciteToHbaseXsltFunctions.getSimpleQualifier(relClass, "dnet:result_result_relations"));
            ResultResultProtos.ResultResult.PublicationDataset.Builder builder = ResultResultProtos.ResultResult.PublicationDataset.newBuilder().setRelMetadata(metadata);
            OafProtos.OafRel.Builder rel = DataciteToHbaseXsltFunctions.getRel(eSource, eTarget, RelTypeProtos.RelType.resultResult, RelTypeProtos.SubRelType.publicationDataset, relClass, false).setResultResult(ResultResultProtos.ResultResult.newBuilder().setPublicationDataset(builder));
            return DataciteToHbaseXsltFunctions.base64(DataciteToHbaseXsltFunctions.getOaf(rel, DataciteToHbaseXsltFunctions.getDataInfo(dataInfo, provenanceAction, trust, false, false)).toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    public static String getFirstItem(NodeList list) {
        String out = "";
        if (list != null && list.getLength() > 0 && list.item(0).getChildNodes() != null && list.item(0).getChildNodes().getLength() > 0) {
            out = list.item(0).getChildNodes().item(0).getNodeValue();
        }
        return out;
    }

    public static String oafResultProject_Outcome_FromDatacite(String source, String target, String relClass, String provenanceAction, String trust, NodeList dataInfo) {
        try {
            String eSource = OafRowKeyDecoder.decode(source).getKey();
            String eTarget = OafRowKeyDecoder.decode(target).getKey();
            RelMetadataProtos.RelMetadata.Builder metadata = RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DataciteToHbaseXsltFunctions.getSimpleQualifier(relClass, "dnet:result_project_relations"));
            ResultProjectProtos.ResultProject.Outcome.Builder outcome = ResultProjectProtos.ResultProject.Outcome.newBuilder().setRelMetadata(metadata);
            OafProtos.OafRel.Builder rel = DataciteToHbaseXsltFunctions.getRel(eSource, eTarget, RelTypeProtos.RelType.resultProject, RelTypeProtos.SubRelType.outcome, relClass, false).setResultProject(ResultProjectProtos.ResultProject.newBuilder().setOutcome(outcome));
            return DataciteToHbaseXsltFunctions.base64(DataciteToHbaseXsltFunctions.getOaf(rel, DataciteToHbaseXsltFunctions.getDataInfo(dataInfo, provenanceAction, trust, false, false)).toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    public static String oafPerson_FromDatacite(String personId, NodeList dataInfo, String fullname, String provenanceAction, String trust, String collectedfromId, String collectedfromName, String originalId, String dateOfCollection) {
        String entityId = OafRowKeyDecoder.decode(personId).getKey();
        try {
            PersonProtos.Person.Builder person = PersonProtos.Person.newBuilder();
            PersonProtos.Person.Metadata.Builder metadata = PersonProtos.Person.Metadata.newBuilder();
            metadata.setFullname(DataciteToHbaseXsltFunctions.sf(fullname));
            Person p = new Person(fullname, false);
            if (p.isAccurate()) {
                metadata.setFirstname(DataciteToHbaseXsltFunctions.sf(Joiner.on((String)" ").join((Iterable)p.getName())));
                metadata.clearSecondnames();
                for (String s : p.getSurname()) {
                    metadata.addSecondnames(DataciteToHbaseXsltFunctions.sf(s));
                }
                metadata.setFullname(DataciteToHbaseXsltFunctions.sf(p.getNormalisedFullname()));
            }
            ArrayList pids = Lists.newArrayList();
            OafProtos.OafEntity.Builder entity = DataciteToHbaseXsltFunctions.getEntity(TypeProtos.Type.person, entityId, DataciteToHbaseXsltFunctions.getKV(collectedfromId, collectedfromName), Lists.newArrayList((Object[])new String[]{originalId}), dateOfCollection, pids).setPerson(person.setMetadata(metadata));
            return DataciteToHbaseXsltFunctions.base64(DataciteToHbaseXsltFunctions.getOaf(entity, DataciteToHbaseXsltFunctions.getDataInfo(dataInfo, provenanceAction, trust, false, false)).toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    public static String oafPersonResult_Authorship_FromDatacite(String source, String target, int rank, String relClass, String provenanceAction, String trust, NodeList dataInfo) {
        try {
            String eSource = OafRowKeyDecoder.decode(source).getKey();
            String eTarget = OafRowKeyDecoder.decode(target).getKey();
            RelMetadataProtos.RelMetadata.Builder metadata = RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DataciteToHbaseXsltFunctions.getSimpleQualifier(relClass, "dnet:personroles"));
            PersonResultProtos.PersonResult.Authorship.Builder auth = PersonResultProtos.PersonResult.Authorship.newBuilder().setRanking("" + rank).setRelMetadata(metadata);
            OafProtos.OafRel.Builder rel = DataciteToHbaseXsltFunctions.getRel(eSource, eTarget, RelTypeProtos.RelType.personResult, RelTypeProtos.SubRelType.authorship, relClass, false).setPersonResult(PersonResultProtos.PersonResult.newBuilder().setAuthorship(auth));
            return DataciteToHbaseXsltFunctions.base64(DataciteToHbaseXsltFunctions.getOaf(rel, DataciteToHbaseXsltFunctions.getDataInfo(dataInfo, provenanceAction, trust, false, false)).toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    static {
        mappingAccess.put("info:eu-repo/semantics/openAccess", "OPEN");
        mappingAccess.put("info:eu-repo/semantics/closedAccess", "CLOSED");
        mappingAccess.put("info:eu-repo/semantics/restrictedAccess", "RESTRICTED");
        mappingAccess.put("info:eu-repo/semantics/embargoedAccess", "EMBARGO");
        mappingAccess.put("OPEN", "OPEN");
        mappingAccess.put("CLOSED", "CLOSED");
        mappingAccess.put("RESTRICTED", "RESTRICTED");
        mappingAccess.put("EMBARGO", "EMBARGO");
    }
}

