/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.DatasourceOrganizationProtos;
import eu.dnetlib.data.proto.DatasourceProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.OrganizationProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.PersonResultProtos;
import eu.dnetlib.data.proto.ProjectOrganizationProtos;
import eu.dnetlib.data.proto.ProjectPersonProtos;
import eu.dnetlib.data.proto.ProjectProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultProjectProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetOafXsltFunctions;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DNetDbToHbaseXsltFunctions
extends AbstractDNetOafXsltFunctions {
    public static String oafEntity(String type, String id, String collectedFromId, String collectedFromName, String originalId, String dateOfCollection, NodeList nodeList) {
        String entityId = OafRowKeyDecoder.decode(id).getKey();
        switch (TypeProtos.Type.valueOf((String)type)) {
            case datasource: {
                return DNetDbToHbaseXsltFunctions.serializeOafEntity(nodeList, TypeProtos.Type.datasource, entityId, DNetDbToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), originalId, dateOfCollection, (Message.Builder)DatasourceProtos.Datasource.newBuilder());
            }
            case organization: {
                return DNetDbToHbaseXsltFunctions.serializeOafEntity(nodeList, TypeProtos.Type.organization, entityId, DNetDbToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), originalId, dateOfCollection, (Message.Builder)OrganizationProtos.Organization.newBuilder());
            }
            case person: {
                return DNetDbToHbaseXsltFunctions.serializeOafEntity(nodeList, TypeProtos.Type.person, entityId, DNetDbToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), originalId, dateOfCollection, (Message.Builder)PersonProtos.Person.newBuilder());
            }
            case project: {
                return DNetDbToHbaseXsltFunctions.serializeOafEntity(nodeList, TypeProtos.Type.project, entityId, DNetDbToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), originalId, dateOfCollection, (Message.Builder)ProjectProtos.Project.newBuilder());
            }
            case result: {
                return DNetDbToHbaseXsltFunctions.serializeOafEntity(nodeList, TypeProtos.Type.result, entityId, DNetDbToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), originalId, dateOfCollection, (Message.Builder)ResultProtos.Result.newBuilder());
            }
        }
        throw new IllegalArgumentException("Invalid entity type: " + type);
    }

    public static String oafRel(String relationType, String source, String target, NodeList nodeList, String relClass, String relScheme) {
        String eSource = OafRowKeyDecoder.decode(source).getKey();
        String eTarget = OafRowKeyDecoder.decode(target).getKey();
        RelTypeProtos.RelType relType = RelTypeProtos.RelType.valueOf((String)relationType);
        switch (relType) {
            case datasourceOrganization: {
                DatasourceOrganizationProtos.DatasourceOrganization.Provision.Builder provision = DatasourceOrganizationProtos.DatasourceOrganization.Provision.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DNetDbToHbaseXsltFunctions.getSimpleQualifier(DatasourceOrganizationProtos.DatasourceOrganization.Provision.RelName.valueOf((String)relClass).toString(), relScheme)));
                DatasourceOrganizationProtos.DatasourceOrganization.Builder dorg = DatasourceOrganizationProtos.DatasourceOrganization.newBuilder().setProvision(provision);
                return DNetDbToHbaseXsltFunctions.serializeOafRel(nodeList, eSource, eTarget, relType, RelTypeProtos.SubRelType.provision, relClass, false, (Message.Builder)dorg, (Message.Builder)provision);
            }
            case personResult: {
                PersonResultProtos.PersonResult.Authorship.Builder auth = PersonResultProtos.PersonResult.Authorship.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DNetDbToHbaseXsltFunctions.getSimpleQualifier(PersonResultProtos.PersonResult.Authorship.RelName.valueOf((String)relClass).toString(), relScheme)));
                PersonResultProtos.PersonResult.Builder personResult = PersonResultProtos.PersonResult.newBuilder().setAuthorship(auth);
                return DNetDbToHbaseXsltFunctions.serializeOafRel(nodeList, eSource, eTarget, relType, RelTypeProtos.SubRelType.authorship, relClass, false, (Message.Builder)personResult, (Message.Builder)auth);
            }
            case projectPerson: {
                ProjectPersonProtos.ProjectPerson.ContactPerson.Builder contact = ProjectPersonProtos.ProjectPerson.ContactPerson.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DNetDbToHbaseXsltFunctions.getSimpleQualifier(ProjectPersonProtos.ProjectPerson.ContactPerson.RelName.valueOf((String)relClass).toString(), relScheme)));
                ProjectPersonProtos.ProjectPerson.Builder projectPerson = ProjectPersonProtos.ProjectPerson.newBuilder().setContactPerson(contact);
                return DNetDbToHbaseXsltFunctions.serializeOafRel(nodeList, eSource, eTarget, relType, RelTypeProtos.SubRelType.contactPerson, relClass, false, (Message.Builder)projectPerson, (Message.Builder)contact);
            }
            case projectOrganization: {
                ProjectOrganizationProtos.ProjectOrganization.Participation.Builder participant = ProjectOrganizationProtos.ProjectOrganization.Participation.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DNetDbToHbaseXsltFunctions.getSimpleQualifier(ProjectOrganizationProtos.ProjectOrganization.Participation.RelName.valueOf((String)relClass).toString(), relScheme)));
                ProjectOrganizationProtos.ProjectOrganization.Builder projectOrganization = ProjectOrganizationProtos.ProjectOrganization.newBuilder().setParticipation(participant);
                return DNetDbToHbaseXsltFunctions.serializeOafRel(nodeList, eSource, eTarget, relType, RelTypeProtos.SubRelType.participation, relClass, false, (Message.Builder)projectOrganization, (Message.Builder)participant);
            }
            case resultProject: {
                ResultProjectProtos.ResultProject.Outcome.Builder outcome = ResultProjectProtos.ResultProject.Outcome.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DNetDbToHbaseXsltFunctions.getSimpleQualifier(ResultProjectProtos.ResultProject.Outcome.RelName.valueOf((String)relClass).toString(), relScheme)));
                ResultProjectProtos.ResultProject.Builder resultProject = ResultProjectProtos.ResultProject.newBuilder().setOutcome(outcome);
                return DNetDbToHbaseXsltFunctions.serializeOafRel(nodeList, eSource, eTarget, relType, RelTypeProtos.SubRelType.outcome, relClass, false, (Message.Builder)resultProject, (Message.Builder)outcome);
            }
        }
        throw new IllegalArgumentException("unhandled relType: " + relationType);
    }

    protected static String serializeOafEntity(NodeList nodelist, TypeProtos.Type type, String id, FieldTypeProtos.KeyValue collectedFrom, String originalId, String dateOfCollection, Message.Builder entity) {
        try {
            Descriptors.FieldDescriptor md = entity.getDescriptorForType().findFieldByName("metadata");
            OafProtos.OafEntity.Builder parent = DNetDbToHbaseXsltFunctions.getEntity(type, id, collectedFrom, Lists.newArrayList((Object[])new String[]{originalId}), dateOfCollection, null);
            Message.Builder metadata = entity.newBuilderForField(md);
            FieldTypeProtos.DataInfo.Builder dataInfo = FieldTypeProtos.DataInfo.newBuilder();
            if (type.equals((Object)TypeProtos.Type.result)) {
                ResultProtos.Result.Instance.Builder instance = ResultProtos.Result.Instance.newBuilder();
                DNetDbToHbaseXsltFunctions.parseNodelist(nodelist, new Message.Builder[]{instance});
                Descriptors.FieldDescriptor instanceDescriptor = ResultProtos.Result.getDescriptor().findFieldByName(ResultProtos.Result.Instance.getDescriptor().getName());
                if (instanceDescriptor != null) {
                    entity.setField(instanceDescriptor, (Object)instance);
                }
            }
            DNetDbToHbaseXsltFunctions.parseNodelist(nodelist, new Message.Builder[]{parent, entity, metadata, dataInfo});
            Descriptors.FieldDescriptor entityDescriptor = OafProtos.OafEntity.getDescriptor().findFieldByName(type.toString());
            OafProtos.Oaf build = DNetDbToHbaseXsltFunctions.getOaf((OafProtos.OafEntity.Builder)parent.setField(entityDescriptor, (Object)entity.setField(md, (Object)metadata.build()).build()), dataInfo);
            return DNetDbToHbaseXsltFunctions.base64(build.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    protected static String serializeOafRel(NodeList nodeList, String sourceId, String targetId, RelTypeProtos.RelType relType, RelTypeProtos.SubRelType subRelType, String relClass, boolean isChild, Message.Builder rel, Message.Builder subRel) {
        try {
            FieldTypeProtos.DataInfo.Builder dataInfo = FieldTypeProtos.DataInfo.newBuilder();
            DNetDbToHbaseXsltFunctions.parseNodelist(nodeList, new Message.Builder[]{rel, subRel, dataInfo});
            OafProtos.OafRel.Builder builder = DNetDbToHbaseXsltFunctions.getRel(sourceId, targetId, relType, subRelType, relClass, isChild);
            Descriptors.FieldDescriptor subRelDescriptor = rel.getDescriptorForType().findFieldByName(subRelType.toString());
            rel.setField(subRelDescriptor, (Object)subRel.build());
            Descriptors.FieldDescriptor relDescriptor = OafProtos.OafRel.getDescriptor().findFieldByName(relType.toString());
            builder.setField(relDescriptor, (Object)rel.build());
            OafProtos.Oaf build = DNetDbToHbaseXsltFunctions.getOaf(builder, dataInfo);
            return DNetDbToHbaseXsltFunctions.base64(build.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    private static void parseNodelist(NodeList nodeList, Message.Builder ... builders) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node fieldNode = nodeList.item(i);
            Node attr = fieldNode.getAttributes().getNamedItem("name");
            String fieldName = attr.getNodeValue();
            NodeList chilidren = fieldNode.getChildNodes();
            for (int j = 0; j < chilidren.getLength(); ++j) {
                Node child = chilidren.item(j);
                String childName = child.getLocalName();
                if (!"ITEM".equals(childName) && !StringUtils.isBlank((String)childName)) continue;
                for (Message.Builder builder : builders) {
                    String text;
                    Descriptors.FieldDescriptor desc = builder.getDescriptorForType().findFieldByName(fieldName);
                    if (desc == null || StringUtils.isBlank((String)(text = DNetDbToHbaseXsltFunctions.getText(StringUtils.isBlank((String)childName) ? fieldNode : child)))) continue;
                    DNetDbToHbaseXsltFunctions.addField(builder, desc, text);
                }
            }
        }
    }

    private static String getText(Node node) {
        StringBuffer result = new StringBuffer();
        if (!node.hasChildNodes()) {
            return "";
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node subnode = list.item(i);
            if (subnode.getNodeType() == 3) {
                result.append(subnode.getNodeValue());
                continue;
            }
            if (subnode.getNodeType() == 4) {
                result.append(subnode.getNodeValue());
                continue;
            }
            if (subnode.getNodeType() != 5) continue;
            result.append(DNetDbToHbaseXsltFunctions.getText(subnode));
        }
        return result.toString().trim();
    }
}

