package eu.dnetlib.data.transform.xml;

import org.w3c.dom.NodeList;

public class DNetMdStoreToHbaseXsltFunctions extends DmfToHbaseXsltFunctions {

	public static final String DEFAULT_TRUST = "0.9";
	public static final String DEFAULT_PROVENANCE = "sysimport:crosswalk:repository";

	// dnet:oafPersonResultFromMDStore($resultId, $oafPerson, position())
	public static String oafPersonResult_Authorship_FromMDStore(final String personId,
			final String resultId,
			final int rank,
			final String relClass,
			final NodeList dataInfo) {
		return oafPersonResult_Authorship_FromDMF(personId, resultId, rank, relClass, DEFAULT_PROVENANCE, DEFAULT_TRUST, dataInfo);
	}

	// dnet:oafPersonResultFromMDStore($resultId, $oafPerson, position())
	public static String oafPersonPerson_CoAuthorship_FromMDStore(final String source, final String target, final String relClass, final NodeList dataInfo) {
		return oafPersonPerson_CoAuthorship_FromDMF(source, target, relClass, DEFAULT_PROVENANCE, DEFAULT_TRUST, dataInfo);
	}

	// dnet:oafResultProjectFromMDStore($resultId, $projectId)
	public static String oafResultProject_Outcome_FromMDStore(final String sourceId, final String targetId, final String relClass, final NodeList dataInfo) {
		return oafResultProject_Outcome_FromDMF(sourceId, targetId, relClass, DEFAULT_PROVENANCE, DEFAULT_TRUST, dataInfo);
	}

	public static String oafResultResult_PublicationDataset_FromMDStore(final String sourceId,
			final String targetId,
			final String relClass,
			final NodeList dataInfo) {
		return oafResultResult_PublicationDataset_FromDMF(sourceId, targetId, relClass, DEFAULT_PROVENANCE, DEFAULT_TRUST, dataInfo);
	}

	// dnet:oafPersonFromMDStore($personId, .)
	public static String oafPersonFromMDStore(final String personId,
			final NodeList dataInfo,
			final String collectedFromId,
			final String collectedFromName,
			final String originalId,
			final String dateOfCollection,
			final String fullname) {
		return oafPerson_FromDMF(personId, fullname, DEFAULT_PROVENANCE, DEFAULT_TRUST, dataInfo, collectedFromId, collectedFromName, originalId,
				dateOfCollection);
	}

	public static String oafResultFromMDStore(final String resultId,
			final NodeList dataInfo,
			final String hostedbyId,
			final String hostedbyName,
			final String collectedFromId,
			final String collectedFromName,
			final String originalId,
			final String dateOfCollection,
			final NodeList metadata) {
		return oafResult_FromDMF(resultId, DEFAULT_PROVENANCE, DEFAULT_TRUST, dataInfo, hostedbyId, hostedbyName, collectedFromId, collectedFromName,
				originalId, dateOfCollection, metadata);
	}

}
