/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractProtoMapper {
    private static final String PATH_SEPARATOR = "/";

    protected List<Object> processMultiPath(GeneratedMessage proto, List<String> paths) {
        ArrayList response = Lists.newArrayList();
        for (String pathElements : paths) {
            response.addAll(this.processPath(proto, pathElements));
        }
        return response;
    }

    protected List<Object> processPath(GeneratedMessage proto, String path) {
        return this.processPath(proto, Lists.newLinkedList((Iterable)Splitter.on((String)PATH_SEPARATOR).trimResults().split((CharSequence)path)));
    }

    protected List<Object> processPath(GeneratedMessage proto, List<String> pathElements) {
        ArrayList response = Lists.newArrayList();
        if (pathElements.isEmpty()) {
            throw new RuntimeException("ProtoBuf navigation path is empty");
        }
        Descriptors.FieldDescriptor fd = proto.getDescriptorForType().findFieldByName(pathElements.get(0));
        if (fd != null) {
            if (fd.isRepeated()) {
                int count = proto.getRepeatedFieldCount(fd);
                for (int i = 0; i < count; ++i) {
                    Object field = proto.getRepeatedField(fd, i);
                    response.addAll(this.generateFields(fd, field, pathElements));
                }
            } else {
                Object field = proto.getField(fd);
                response.addAll(this.generateFields(fd, field, pathElements));
            }
        } else {
            throw new RuntimeException("Invalid protobuf path (field not found): " + StringUtils.join(pathElements, (String)">"));
        }
        return response;
    }

    private List<Object> generateFields(Descriptors.FieldDescriptor fd, Object field, List<String> list) {
        if (field instanceof GeneratedMessage) {
            if (list.size() > 1) {
                return this.processPath((GeneratedMessage)field, list.subList(1, list.size()));
            }
            throw new RuntimeException("No primitive type found");
        }
        if (list.size() == 1) {
            ArrayList res = Lists.newArrayList();
            switch (fd.getType()) {
                case ENUM: {
                    res.add(((Descriptors.EnumValueDescriptor)field).getName());
                    break;
                }
                default: {
                    res.add(field);
                }
            }
            return res;
        }
        throw new RuntimeException("Found a primitive type before the path end");
    }
}

