package eu.dnetlib.data.transform.xml;

import java.util.List;
import java.util.Map;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos.StructuredProperty;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.OafProtos.OafRel;
import eu.dnetlib.data.proto.PersonProtos.Person;
import eu.dnetlib.data.proto.PersonResultProtos.PersonResult;
import eu.dnetlib.data.proto.PersonResultProtos.PersonResult.Authorship;
import eu.dnetlib.data.proto.RelMetadataProtos.RelMetadata;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;
import eu.dnetlib.data.proto.RelTypeProtos.SubRelType;
import eu.dnetlib.data.proto.ResultProjectProtos.ResultProject;
import eu.dnetlib.data.proto.ResultProjectProtos.ResultProject.Outcome;
import eu.dnetlib.data.proto.ResultProtos.Result;
import eu.dnetlib.data.proto.ResultProtos.Result.Instance;
import eu.dnetlib.data.proto.ResultResultProtos.ResultResult;
import eu.dnetlib.data.proto.ResultResultProtos.ResultResult.PublicationDataset;
import eu.dnetlib.data.proto.TypeProtos.Type;

public class DataciteToHbaseXsltFunctions extends AbstractDNetOafXsltFunctions {

	private static Map<String, String> mappingAccess = Maps.newHashMap();

	static {

		mappingAccess.put("info:eu-repo/semantics/openAccess", "OPEN");
		mappingAccess.put("info:eu-repo/semantics/closedAccess", "CLOSED");
		mappingAccess.put("info:eu-repo/semantics/restrictedAccess", "RESTRICTED");
		mappingAccess.put("info:eu-repo/semantics/embargoedAccess", "EMBARGO");

	}

	public static String oafResult_FromDatacite(final String resultId,
			final NodeList dataInfo,
			final NodeList metadata,
			final NodeList titles,
			final NodeList subjects,
			final NodeList publisher,
			final NodeList descriptions,
			final NodeList dates,
			final NodeList dateaccepted,
			final NodeList resourceTypes,
			final NodeList formats,
			final NodeList sizes,
			final NodeList languages,
			final NodeList cobjcategory,
			final NodeList rights,
			final NodeList version,
			final String provenance,
			final String trust,
			final String hostedbyId,
			final String hostedbyName,
			final String collectedfromId,
			final String collectedfromName,
			final String originalId,
			final String instanceUri,
			final String dateOfCollection) {

		try {
			final String entityId = OafRowKeyDecoder.decode(resultId).getKey();

			final Result.Builder result = Result.newBuilder();
			Result.Metadata.Builder metadataProto = Result.Metadata.newBuilder();

			// subject
			for (int i = 0; i < subjects.getLength(); i++) {
				Node currentNode = subjects.item(i);
				NodeList childNodes = currentNode.getChildNodes();
				if (childNodes.getLength() > 0) {
					String subjectValue = childNodes.item(0).getNodeValue();
					addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("subject"),
							getStructuredProperty(subjectValue, "keyword", "keyword", "dnet:result_subject", "dnet:result_subject"));
				}
			}

			// title
			for (int i = 0; i < titles.getLength(); i++) {
				Node currentNode = titles.item(i);
				NodeList childNodes = currentNode.getChildNodes();
				if (childNodes.getLength() > 0) {
					String titleValue = childNodes.item(0).getNodeValue();
					String classname = "main title";
					String classid = "main title";
					if (currentNode.hasAttributes()) {
						NamedNodeMap attributes = currentNode.getAttributes();
						Node titleType = attributes.getNamedItem("titleType");

						if ((titleType != null) && titleType.getNodeValue().equals("AlternativeTitle")) {
							classname = "alternative title";
							classid = "alternative title";
						}
						if ((titleType != null) && titleType.getNodeValue().equals("Subtitle")) {
							classname = "subtitle";
							classid = "subtitle";
						}
						if ((titleType != null) && titleType.getNodeValue().equals("TranslatedTitle")) {
							classname = "translated title";
							classid = "translated title";
						}
					}
					addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("title"),
							getStructuredProperty(titleValue, classname, classid, "dnet:dataCite_title", "dnet:dataCite_title"));
				}
			}

			// description
			for (int i = 0; i < descriptions.getLength(); i++) {
				Node currentNode = descriptions.item(i);
				if ((currentNode != null) && currentNode.hasChildNodes()) {
					String descriptionValue = currentNode.getChildNodes().item(0).getNodeValue();
					addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("description"), descriptionValue);
				}
			}

			// publisher
			addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("publisher"), getFirstItem(publisher));

			// dates
			for (int i = 0; i < dates.getLength(); i++) {
				Node currentNode = dates.item(i);
				if ((currentNode != null) && currentNode.hasAttributes() && currentNode.hasChildNodes()) {
					String dateAttribute = currentNode.getAttributes().getNamedItem("dateType").getNodeValue();
					String dateValue = currentNode.getChildNodes().item(0).getNodeValue();
					String protoAttribute = "relevantdate";
					if ("Accepted".equals(dateAttribute)) {
						protoAttribute = "dateofacceptance";
					} else if ("Issued".equals(dateAttribute)) {
						protoAttribute = "storagedate";
					} else if ("Updated".equals(dateAttribute)) {
						protoAttribute = "lastmetadataupdate";
					} else if ("Available".equals(dateAttribute)) {
						protoAttribute = "embargoenddate";
					}
					if (protoAttribute.equals("relevantdate") == false) {
						addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName(protoAttribute), dateValue);
					} else {
						addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName(protoAttribute),
								getStructuredProperty(dateValue, "UNKNOWN", "UNKNOWN", "dnet:dataCite_date", "dnet:dataCite_date"));
					}
				}
			}

			// dateofacceptance
			addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("dateofacceptance"), getFirstItem(dateaccepted));

			// size
			addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("size"), getFirstItem(sizes));

			// format
			addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("format"), getFirstItem(formats));

			// version
			addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("version"), getFirstItem(version));

			// language
			addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("language"),
					setQualifier(getDefaultQualifier("dnet:languages"), Lists.newArrayList(getFirstItem(languages))));

			// resultType
			addField(metadataProto, Result.Metadata.getDescriptor().findFieldByName("resulttype"), getSimpleQualifier("dataset", "dnet:result_typologies"));

			String tmpID;
			String TmpName;

			if ((hostedbyId == null) && (hostedbyName == null)) {
				tmpID = collectedfromId;
				TmpName = collectedfromName;
			} else {
				tmpID = hostedbyId;
				TmpName = hostedbyName;
			}

			final Instance.Builder instance = Instance.newBuilder().setHostedby(getKV(tmpID, TmpName));

			String tmpRigths = "UNKNOWN";
			final String firstRight = getFirstItem(rights);
			if (mappingAccess.containsKey(firstRight)) {
				tmpRigths = mappingAccess.get(firstRight);
			}

			addField(instance, Instance.getDescriptor().findFieldByName("licence"),
					setQualifier(getDefaultQualifier("dnet:access_modes"), Lists.newArrayList(tmpRigths)));

			addField(instance, Instance.getDescriptor().findFieldByName("instancetype"),
					setQualifier(getDefaultQualifier("dnet:dataCite_resource"), Lists.newArrayList(getFirstItem(cobjcategory))));

			addField(instance, Instance.getDescriptor().findFieldByName("url"), instanceUri);

			result.addInstance(instance);

			List<StructuredProperty> pids = Lists.newArrayList();
			OafEntity.Builder entity =
					getEntity(Type.result, entityId, getKV(collectedfromId, collectedfromName), originalId, dateOfCollection, pids).setResult(
							result.setMetadata(metadataProto));
			Oaf oaf = getOaf(entity, getDataInfo(dataInfo, provenance, trust, false, false));
			return base64(oaf.toByteArray());
		} catch (Exception e) {
			e.printStackTrace(System.err);
			throw new RuntimeException(e);
		}

	}

	// dnet:dnet:oafResultResultFromMDStore($relatedId, $resultId)
	public static String oafResultResult_PublicationDataset_FromDatacite(final String source,
			final String target,
			final String relClass,
			final String provenanceAction,
			final String trust,
			final NodeList dataInfo) {
		try {
			final String eSource = OafRowKeyDecoder.decode(source).getKey();
			final String eTarget = OafRowKeyDecoder.decode(target).getKey();

			final RelMetadata.Builder metadata = RelMetadata.newBuilder().setSemantics(getSimpleQualifier(relClass, "dnet:result_result_relations"));
			final PublicationDataset.Builder builder = PublicationDataset.newBuilder().setRelMetadata(metadata);

			OafRel.Builder rel =
					getRel(eSource, eTarget, RelType.resultResult, SubRelType.publicationDataset, relClass, false).setResultResult(
							ResultResult.newBuilder().setPublicationDataset(builder));

			return base64(getOaf(rel, getDataInfo(dataInfo, provenanceAction, trust, false, false)).toByteArray());
		} catch (Exception e) {
			e.printStackTrace(System.err);
			throw new RuntimeException(e);
		}
	}

	public static String getFirstItem(final NodeList list) {
		String out = "";
		if (list != null) {

			if ((list.getLength() > 0) && (list.item(0).getChildNodes() != null) && (list.item(0).getChildNodes().getLength() > 0)) {
				out = list.item(0).getChildNodes().item(0).getNodeValue();
			}
		}
		return out;
	}

	// dnet:oafResultProjectFromDMF($resultId, $projectId, "sysimport:crosswalk:repository", "0.9")
	public static String oafResultProject_Outcome_FromDatacite(final String source,
			final String target,
			final String relClass,
			final String provenanceAction,
			final String trust,
			final NodeList dataInfo) {
		try {
			final String eSource = OafRowKeyDecoder.decode(source).getKey();
			final String eTarget = OafRowKeyDecoder.decode(target).getKey();

			final RelMetadata.Builder metadata = RelMetadata.newBuilder().setSemantics(getSimpleQualifier(relClass, "dnet:result_project_relations"));
			final Outcome.Builder outcome = Outcome.newBuilder().setRelMetadata(metadata);

			OafRel.Builder rel =
					getRel(eSource, eTarget, RelType.resultProject, SubRelType.outcome, relClass, false).setResultProject(
							ResultProject.newBuilder().setOutcome(outcome));

			return base64(getOaf(rel, getDataInfo(dataInfo, provenanceAction, trust, false, false)).toByteArray());
		} catch (Exception e) {
			e.printStackTrace(System.err);
			throw new RuntimeException(e);
		}
	}

	public static String oafPerson_FromDatacite(final String personId,
			final NodeList dataInfo,
			final String fullname,
			final String provenanceAction,
			final String trust,
			final String collectedfromId,
			final String collectedfromName,
			final String originalId,
			final String dateOfCollection) {

		final String entityId = OafRowKeyDecoder.decode(personId).getKey();
		try {
			final Person.Builder person = Person.newBuilder();
			final Person.Metadata.Builder metadata = Person.Metadata.newBuilder();

			metadata.setFullname(sf(fullname));

			eu.dnetlib.pace.model.Person p = new eu.dnetlib.pace.model.Person(fullname, false);
			if (p.isAccurate()) {
				metadata.setFirstname(sf(Joiner.on(" ").join(p.getName())));
				metadata.clearSecondnames();
				for (String s : p.getSurname()) {
					metadata.addSecondnames(sf(s));
				}
				metadata.setFullname(sf(p.getNormalisedFullname()));
			}

			// metadata.setNationality(getSimpleQualifier("UNKNOWN", "dnet:countries"));
			List<StructuredProperty> pids = Lists.newArrayList();
			OafEntity.Builder entity =
					getEntity(Type.person, entityId, getKV(collectedfromId, collectedfromName), originalId, dateOfCollection, pids).setPerson(
							person.setMetadata(metadata));

			return base64(getOaf(entity, getDataInfo(dataInfo, provenanceAction, trust, false, false)).toByteArray());
		} catch (Exception e) {
			e.printStackTrace(System.err);
			throw new RuntimeException(e);
		}
	}

	public static String oafPersonResult_Authorship_FromDatacite(final String source,
			final String target,
			final int rank,
			final String relClass,
			final String provenanceAction,
			final String trust,
			final NodeList dataInfo) {
		try {
			final String eSource = OafRowKeyDecoder.decode(source).getKey();
			final String eTarget = OafRowKeyDecoder.decode(target).getKey();

			final RelMetadata.Builder metadata = RelMetadata.newBuilder().setSemantics(getSimpleQualifier(relClass, "dnet:personroles"));
			final Authorship.Builder auth = Authorship.newBuilder().setRanking("" + rank).setRelMetadata(metadata);

			OafRel.Builder rel =
					getRel(eSource, eTarget, RelType.personResult, SubRelType.authorship, relClass, false).setPersonResult(
							PersonResult.newBuilder().setAuthorship(auth));

			return base64(getOaf(rel, getDataInfo(dataInfo, provenanceAction, trust, false, false)).toByteArray());
		} catch (Exception e) {
			e.printStackTrace(System.err);
			throw new RuntimeException(e);
		}
	}

}
