<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:dnet="eu.dnetlib.actionmanager.actions.infopackage.DataciteInfoPackageToHbaseXsltFunctions"
    xmlns:oaf="http://namespace.openaire.eu/oaf"
    xmlns:dri="http://www.driver-repository.eu/namespace/dri"
    xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:exslt="http://exslt.org/common"
    extension-element-prefixes="exslt" exclude-result-prefixes="xsl dnet exslt oaf dr dri">

    <xsl:output omit-xml-declaration="yes" indent="yes"/>

    <xsl:param name="trust" select="string('0.9')"/>
    <xsl:param name="provenance" select="string('UNKNOWN')"/>
    <xsl:param name="namespaceprefix" select="string('datacite____')"/>

    <xsl:template match="/*">
		<xsl:variable name="dataInfo" select="/*[local-name() = 'record']/*[local-name() = 'about']/*[local-name() = 'datainfo']"/>
        <xsl:variable name="metadata" select="exslt:node-set(/*[local-name()='record']/*[local-name()='metadata']/*[local-name()='resource'])"/>
        <xsl:variable name="rightNSPrefix">
            <xsl:choose>
                <xsl:when test="not($namespaceprefix)">
                    <xsl:value-of select="//oaf:datasourceprefix"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$namespaceprefix"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:choose>
            <xsl:when test="count($metadata) =  0">
                <ACTIONS/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="originalId" select="/record/metadata/*[local-name() = 'identifier' and ./@identifierType='DOI']"/>
                <xsl:variable name="resultId" select="dnet:oafSimpleId('result', //dri:objIdentifier)"/>

                <xsl:variable name="creators" select="//*[local-name() = 'creator']"/>
                <xsl:variable name="titles" select="//*[local-name() = 'title']"/>
                <xsl:variable name="subjects" select="//*[local-name() = 'subject']"/>
                <xsl:variable name="publisher" select="//*[local-name() = 'publisher']"/>
                <xsl:variable name="descriptions" select="//*[local-name() = 'description']"/>
                <xsl:variable name="dates" select="//*[local-name() = 'date']"/>
                <xsl:variable name="dateaccepted" select="//oaf:dateAccepted" />
                <xsl:variable name="resourceType" select="//*[local-name() = 'resourceType']"/>
                <xsl:variable name="formats" select="//*[local-name() = 'format']"/>
                <xsl:variable name="sizes" select="//*[local-name() = 'size']"/>
                <xsl:variable name="rights" select="//*[local-name() = 'rights']"/>
                <xsl:variable name="version" select="//*[local-name() = 'version']"/>
                <xsl:variable name="instanceURI" select="concat('http://dx.doi.org', '/', //*[local-name() = 'resource']/*[local-name() = 'identifier'])"/>
                <xsl:variable name="hostedbyid" select="dnet:oafSplitId('datasource', //oaf:hostedBy/@id)"/>
                <xsl:variable name="hostedbyname" select="//oaf:hostedBy/@name"/>
                <xsl:variable name="collectedfromid" select="dnet:oafSplitId('datasource', //oaf:collectedFrom/@id)"/>
                <xsl:variable name="collectedfromname" select="//oaf:collectedFrom/@name"/>
                <xsl:variable name="dateOfCollection" select="//dr:dateOfCollection"/>
                <xsl:variable name="language" select="//oaf:language" />
				<xsl:variable name="cobjcategory" select="//dr:CobjCategory" />

                <ACTIONS>
                    <ACTION targetKey="{$resultId}" targetColumnFamily="result"
                        targetColumn="body">
                        <xsl:value-of
                            select="dnet:oafDataCiteResultFromInfoPackage($resultId, $dataInfo, $metadata, $titles, 
                            $subjects, $publisher, $descriptions, $dates, $dateaccepted, $resourceType, 
                            $formats, $sizes, $language, $cobjcategory, $rights, $version, $provenance, $trust, $hostedbyid, $hostedbyname,
                            $collectedfromid, $collectedfromname, $originalId, $instanceURI, $dateOfCollection)"
                        />
                    </ACTION>

                    <xsl:for-each select="//*[local-name() = 'creator']">
                        <xsl:variable name="personIdTemp">
                            <xsl:choose>
                                <xsl:when test="string-length(./*[local-name() = 'nameIdentifier']) &gt; 0">
                                    <xsl:value-of
                                        select="translate(normalize-space(./*[local-name() = 'nameIdentifier']),' .,','___')"
                                    />
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of
                                        select="translate(normalize-space(./*[local-name() = 'creatorName']),' .,','___')"
                                    />
                                </xsl:otherwise>
                            </xsl:choose>

                        </xsl:variable>
                        
                        <xsl:variable name="personId" select="dnet:oafId('person', $namespaceprefix, concat($originalId, '::', normalize-space($personIdTemp)))"/>
                        
                        <xsl:variable name="originalPersonId" select="./*[local-name() = 'nameIdentifier']"/>
                        <xsl:if test="string-length($personId) &gt; 0">
                            <ACTION targetKey="{$personId}" targetColumnFamily="person" targetColumn="body">                                
                                <xsl:value-of
                                    select="dnet:oafDataCitePersonFromInfoPackage($personId, $dataInfo, normalize-space(./*[local-name() = 'creatorName']), $provenance, $trust, $collectedfromid, $collectedfromname,$originalPersonId, $dateOfCollection)"
                                />
                            </ACTION>
                            <ACTION targetKey="{$personId}" targetColumnFamily="personResult_authorship_isAuthorOf"
                                targetColumn="{$resultId}">
                                <xsl:value-of
                                    select="dnet:oafDataCitePersonResultFromInfoPackage($personId, $resultId, position(), 'isAuthorOf', $provenance, $trust, $dataInfo)"
                                />
                            </ACTION>
                            <ACTION targetKey="{$resultId}" targetColumnFamily="personResult_authorship_hasAuthor"
                                targetColumn="{$personId}">
                                <xsl:value-of
                                    select="dnet:oafDataCitePersonResultFromInfoPackage($resultId, $personId, position(), 'hasAuthor', $provenance, $trust, $dataInfo)"
                                />
                            </ACTION>
                        </xsl:if>
                    	</xsl:for-each>
						<xsl:for-each select="//*[local-name()='relatedPublication']">
	
							<!-- relatedDataset ids must be in the openaire format  -->
							<xsl:variable name="publicationId" select="dnet:oafSimpleId('result', normalize-space(./@id))"/>
							
							<xsl:if test="string-length($publicationId) &gt; 0">

								<xsl:variable name="resultDataset" select="dnet:oafDataCitePublicationDatasetFromInfoPackage($resultId, $publicationId, 'isRelatedTo', $provenance, $trust, $dataInfo)"/>
								<xsl:variable name="datasetResult" select="dnet:oafDataCitePublicationDatasetFromInfoPackage($publicationId, $resultId, 'isRelatedTo', $provenance, $trust, $dataInfo)"/>

								<ACTION targetKey="{$resultId}" targetColumnFamily="resultResult_publicationDataset_isRelatedTo"
									targetColumn="{$publicationId}"><xsl:value-of select="$resultDataset"/>
								</ACTION>
								<ACTION targetKey="{$publicationId}" targetColumnFamily="resultResult_publicationDataset_isRelatedTo"
									targetColumn="{$resultId}"><xsl:value-of select="$datasetResult"/>
								</ACTION>
							</xsl:if>							
						</xsl:for-each>	                    
                </ACTIONS>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
