<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dri="http://www.driver-repository.eu/namespace/dri"
	xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf"
	xmlns:dnet="eu.dnetlib.actionmanager.actions.infopackage.DMFInfoPackageToHbaseXsltFunctions"
	xmlns:exslt="http://exslt.org/common" xmlns:action="http://namespace.openaire.eu/action" 
	extension-element-prefixes="exslt"
	exclude-result-prefixes="xsl dc dr dri oaa oaf dnet exslt">

	<xsl:output omit-xml-declaration="yes" indent="yes" />

	<xsl:param name="trust" select="string('0.9')" />
	<xsl:param name="provenance" select="string('UNKNOWN')" />
	<xsl:param name="namespaceprefix" select="string('unknown_____')" />

	<xsl:template match="/*">
		<xsl:variable name="dataInfo" select="/*[local-name() = 'record']/*[local-name() = 'about']/*[local-name() = 'datainfo']"/>
		<xsl:variable name="dateofcollection" select="//dr:dateOfCollection"/>

		<xsl:variable name="metadata" select="exslt:node-set(//*[local-name()='metadata']/*)" />
		<xsl:variable name="collectedDatasourceid">
			<xsl:choose>
				<xsl:when test="string-length(//oaf:collectedDatasourceid) &gt; 0">
					<xsl:value-of select="//oaf:collectedDatasourceid" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="UNKNOWN" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="count($metadata) = 0">
				<ACTIONS />
			</xsl:when>
			<xsl:otherwise>
			
				<xsl:variable name="objidentifier" select="/record/*[local-name() = 'header']/*[local-name() = 'objIdentifier']" />

				<xsl:variable name="resultId" select="dnet:oafSimpleId('result', $objidentifier)" />
				
				<xsl:variable name="hostedbyid" select="dnet:oafSplitId('datasource', //oaf:hostedBy/@id)" />
				<xsl:variable name="hostedbyname" select="//oaf:hostedBy/@name" />
				
				<xsl:variable name="collectedfromid" select="dnet:oafSplitId('datasource', //oaf:collectedFrom/@id)" />
				<xsl:variable name="collectedfromname" select="//oaf:collectedFrom/@name" />		
				
<!-- 				<xsl:variable name="country" select="substring(//dr:repositoryCountry,  1, 200)" /> -->
<!-- 				<xsl:variable name="accessmode" select="substring(//oaf:accessrights,   1, 200)" /> -->
				
				<xsl:variable name="result" select="dnet:oafResultFromInfoPackage($resultId, $dataInfo, $provenance, $trust, $hostedbyid, $hostedbyname, $collectedfromid, $collectedfromname, $objidentifier, $dateofcollection, $metadata)" />

				<ACTIONS> 
					<ACTION targetKey="{$resultId}" targetColumnFamily="result" targetColumn="body">
						<xsl:value-of select="$result" />
					</ACTION>

<!-- 					<xsl:variable name="instance" select="dnet:oafInstanceFromInfoPackage($resultId, $hostedbyid, $hostedbyname, $provenance, $trust, $metadata)" /> -->

<!-- 					<ACTION targetKey="{$resultId}" targetColumnFamily="instance" targetColumn="{$resultId}"> -->
<!-- 						<xsl:value-of select="$instance" /> -->
<!-- 					</ACTION> -->

					<xsl:for-each select="//*[local-name()='projectid']">

						<xsl:variable name="projectId" select="dnet:oafSplitId('project', normalize-space(.))"/>

						<xsl:variable name="resultproject" select="dnet:oafResultProjectFromInfoPackage($resultId, $projectId, 'isProducedBy', $provenance, $trust, $dataInfo)" />
						<xsl:variable name="projectresult" select="dnet:oafResultProjectFromInfoPackage($projectId, $resultId, 'produces', $provenance, $trust, $dataInfo)" />

						<xsl:if test="string-length($projectId) &gt; 0">
							<ACTION targetKey="{$resultId}" targetColumnFamily="resultProject_outcome_isProducedBy" targetColumn="{$projectId}">
								<xsl:value-of select="$resultproject" />
							</ACTION>
							<ACTION targetKey="{$projectId}" targetColumnFamily="resultProject_outcome_produces" targetColumn="{$resultId}">
								<xsl:value-of select="$projectresult" />
							</ACTION>
						</xsl:if>
					</xsl:for-each>

					<xsl:for-each select="//dc:creator">
					
						<xsl:variable name="personId" select="dnet:oafId('person', $namespaceprefix, concat($objidentifier, '::', .))" />
						
						<xsl:variable name="person" select="dnet:oafPersonFromInfoPackage($personId, $dataInfo, ., $provenance, $trust, $collectedfromid, $collectedfromname, $objidentifier, $dateofcollection)" />
						<xsl:variable name="personresult" select="dnet:oafPersonResultFromInfoPackage($personId, $resultId, position(), 'isAuthorOf', $provenance, $trust, $dataInfo)" />
						<xsl:variable name="resultperson" select="dnet:oafPersonResultFromInfoPackage($resultId, $personId, position(), 'hasAuthor', $provenance, $trust, $dataInfo)" />
						<xsl:if test="string-length($personId) &gt; 0">
							<ACTION targetKey="{$personId}" targetColumnFamily="person" targetColumn="body">
								<xsl:value-of select="$person" />
							</ACTION>
							<ACTION targetKey="{$personId}" targetColumnFamily="personResult_authorship_isAuthorOf" targetColumn="{$resultId}">
								<xsl:value-of select="$personresult" />
							</ACTION>
							<ACTION targetKey="{$resultId}" targetColumnFamily="personResult_authorship_hasAuthor" targetColumn="{$personId}">
								<xsl:value-of select="$resultperson" />
							</ACTION>
						</xsl:if>
					</xsl:for-each>
					
				</ACTIONS>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
