/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.collect.Maps;
import eu.dnetlib.data.transform.xml.Element;
import eu.dnetlib.data.transform.xml.ElementList;
import java.util.HashMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValueMap
extends HashMap<String, ElementList> {
    public static ValueMap parseNodeList(NodeList nodeList) {
        ValueMap values = new ValueMap();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ValueMap.getNodeValue(nodeList.item(i), values);
        }
        return values;
    }

    protected static void getNodeValue(Node node, ValueMap values) {
        String nodeName = node.getLocalName().toLowerCase();
        Node nodeText = node.getFirstChild();
        Element element = nodeText != null ? new Element(nodeText.getNodeValue()) : new Element();
        HashMap attrs = Maps.newHashMap();
        NamedNodeMap attributeList = node.getAttributes();
        for (int j = 0; j < attributeList.getLength(); ++j) {
            Node attr = attributeList.item(j);
            if (attr.getNodeValue() == null || attr.getNodeValue().isEmpty()) continue;
            attrs.put(attr.getLocalName(), attr.getNodeValue());
        }
        element.setAttributes(attrs);
        if (!element.isEmpty()) {
            if (!values.containsKey(nodeName)) {
                values.put(nodeName, new ElementList());
            }
            values.get(nodeName).add(element);
        }
    }

    @Override
    public ElementList get(Object key) {
        ElementList e = (ElementList)super.get(key);
        return e != null ? e : new ElementList();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (String k : this.keySet()) {
            sb.append(k).append("=").append(this.get(k)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }
}

