/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonPersonProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.PersonResultProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultProjectProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetOafXsltFunctions;
import eu.dnetlib.data.transform.xml.Element;
import eu.dnetlib.data.transform.xml.ElementList;
import eu.dnetlib.data.transform.xml.ValueMap;
import eu.dnetlib.pace.model.Person;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.NodeList;

public class DmfToHbaseXsltFunctions
extends AbstractDNetOafXsltFunctions {
    public static String oafPersonResult_Authorship_FromDMF(String source, String target, int rank, String relClass, String provenanceAction, String trust, NodeList dataInfo) {
        try {
            String eSource = OafRowKeyDecoder.decode(source).getKey();
            String eTarget = OafRowKeyDecoder.decode(target).getKey();
            PersonResultProtos.PersonResult.Authorship.Builder auth = PersonResultProtos.PersonResult.Authorship.newBuilder().setRanking("" + rank).setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DmfToHbaseXsltFunctions.getSimpleQualifier(relClass, "dnet:personroles")));
            OafProtos.OafRel.Builder rel = DmfToHbaseXsltFunctions.getRel(eSource, eTarget, RelTypeProtos.RelType.personResult, RelTypeProtos.SubRelType.authorship, relClass, false).setPersonResult(PersonResultProtos.PersonResult.newBuilder().setAuthorship(auth));
            return DmfToHbaseXsltFunctions.base64(DmfToHbaseXsltFunctions.getOaf(rel, DmfToHbaseXsltFunctions.getDataInfo(dataInfo, provenanceAction, trust, false, false)).toByteArray());
        }
        catch (Throwable e) {
            System.err.println("source: " + source);
            System.err.println("target: " + target);
            System.err.println("provenanceAction: " + provenanceAction);
            System.err.println("trust: " + trust);
            System.err.println("rank: " + rank);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String oafPersonPerson_CoAuthorship_FromDMF(String source, String target, String relClass, String provenanceAction, String trust, NodeList dataInfo) {
        try {
            String eSource = OafRowKeyDecoder.decode(source).getKey();
            String eTarget = OafRowKeyDecoder.decode(target).getKey();
            PersonPersonProtos.PersonPerson.Builder pp = PersonPersonProtos.PersonPerson.newBuilder();
            PersonPersonProtos.PersonPerson.CoAuthorship.Builder coauth = PersonPersonProtos.PersonPerson.CoAuthorship.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DmfToHbaseXsltFunctions.getSimpleQualifier(relClass, "dnet:personroles")));
            OafProtos.OafRel.Builder rel = DmfToHbaseXsltFunctions.getRel(eSource, eTarget, RelTypeProtos.RelType.personPerson, RelTypeProtos.SubRelType.coauthorship, relClass, false).setPersonPerson(pp.setCoauthorship(coauth));
            return DmfToHbaseXsltFunctions.base64(DmfToHbaseXsltFunctions.getOaf(rel, DmfToHbaseXsltFunctions.getDataInfo(dataInfo, provenanceAction, trust, false, false)).toByteArray());
        }
        catch (Throwable e) {
            System.err.println("source: " + source);
            System.err.println("target: " + target);
            System.err.println("provenanceAction: " + provenanceAction);
            System.err.println("trust: " + trust);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String oafPerson_FromDMF(String personId, String fullname, String provenanceAction, String trust, NodeList dataInfo, String collectedFromId, String collectedFromName, String originalId, String dateOfCollection) {
        try {
            String entityId = OafRowKeyDecoder.decode(personId).getKey();
            PersonProtos.Person.Builder person = PersonProtos.Person.newBuilder();
            PersonProtos.Person.Metadata.Builder metadata = PersonProtos.Person.Metadata.newBuilder();
            metadata.setFullname(DmfToHbaseXsltFunctions.sf(fullname));
            Person p = new Person(fullname, false);
            if (p.isAccurate()) {
                metadata.setFirstname(DmfToHbaseXsltFunctions.sf(p.getNormalisedFirstName()));
                metadata.clearSecondnames().addSecondnames(DmfToHbaseXsltFunctions.sf(p.getNormalisedSurname()));
                metadata.setFullname(DmfToHbaseXsltFunctions.sf(p.getNormalisedFullname()));
            }
            ArrayList pids = Lists.newArrayList((Object[])new FieldTypeProtos.StructuredProperty[]{DmfToHbaseXsltFunctions.getStructuredProperty(originalId, "oai", "oai", "dnet:pid_types", "dnet:pid_types")});
            OafProtos.OafEntity.Builder entity = DmfToHbaseXsltFunctions.getEntity(TypeProtos.Type.person, entityId, DmfToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), originalId, dateOfCollection, pids).setPerson(person.setMetadata(metadata));
            return DmfToHbaseXsltFunctions.base64(DmfToHbaseXsltFunctions.getOaf(entity, DmfToHbaseXsltFunctions.getDataInfo(dataInfo, provenanceAction, trust, false, false)).toByteArray());
        }
        catch (Throwable e) {
            System.err.println("personId: " + personId);
            System.err.println("fullname: " + fullname);
            System.err.println("provenanceAction: " + provenanceAction);
            System.err.println("trust: " + trust);
            System.err.println("collectedFromId: " + collectedFromId);
            System.err.println("collectedFromName: " + collectedFromName);
            System.err.println("originalId: " + originalId);
            System.err.println("dateOfCollection: " + dateOfCollection);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String oafResultProject_Outcome_FromDMF(String source, String target, String relClass, String provenanceAction, String trust, NodeList dataInfo) {
        try {
            String eSource = OafRowKeyDecoder.decode(source).getKey();
            String eTarget = OafRowKeyDecoder.decode(target).getKey();
            ResultProjectProtos.ResultProject.Outcome.Builder outcome = ResultProjectProtos.ResultProject.Outcome.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DmfToHbaseXsltFunctions.getSimpleQualifier(relClass, "dnet:result_project_relations")));
            ResultProjectProtos.ResultProject.Builder rp = ResultProjectProtos.ResultProject.newBuilder().setOutcome(outcome);
            OafProtos.OafRel.Builder rel = DmfToHbaseXsltFunctions.getRel(eSource, eTarget, RelTypeProtos.RelType.resultProject, RelTypeProtos.SubRelType.outcome, relClass, false).setResultProject(rp);
            return DmfToHbaseXsltFunctions.base64(DmfToHbaseXsltFunctions.getOaf(rel, DmfToHbaseXsltFunctions.getDataInfo(dataInfo, provenanceAction, trust, false, false)).toByteArray());
        }
        catch (Throwable e) {
            System.err.println("source: " + source);
            System.err.println("target: " + target);
            System.err.println("provenanceAction: " + provenanceAction);
            System.err.println("trust: " + trust);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String oafResultProject_Outcome_FromDMF(String source, String target, String relClass, String provenanceAction, String trust) {
        return DmfToHbaseXsltFunctions.oafResultProject_Outcome_FromDMF(source, target, relClass, provenanceAction, trust, null);
    }

    public static String oafResult_FromDMF(String resultId, String provenanceAction, String trust, NodeList dataInfo, String hostedbyId, String hostedbyName, String collectedFromId, String collectedFromName, String originalId, String dateOfCollection, NodeList nodelist) {
        try {
            String entityId = OafRowKeyDecoder.decode(resultId).getKey();
            ResultProtos.Result.Builder result = ResultProtos.Result.newBuilder();
            ValueMap values = ValueMap.parseNodeList(nodelist);
            ResultProtos.Result.Metadata.Builder metadata = ResultProtos.Result.Metadata.newBuilder();
            Descriptors.Descriptor mDesc = ResultProtos.Result.Metadata.getDescriptor();
            DmfToHbaseXsltFunctions.addStructuredProps((Message.Builder)metadata, mDesc.findFieldByName("subject"), values.get("subject").listValues(), "keyword", "dnet:result_subject");
            DmfToHbaseXsltFunctions.addStructuredProps((Message.Builder)metadata, mDesc.findFieldByName("title"), values.get("title").listValues(), "main title", "dnet:dataCite_title");
            for (String fieldname : Lists.newArrayList((Object[])new String[]{"description", "source"})) {
                if (values.get(fieldname) == null) continue;
                for (String s : values.get(fieldname).listValues()) {
                    DmfToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName(fieldname), s);
                }
            }
            DmfToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("language"), DmfToHbaseXsltFunctions.setQualifier(DmfToHbaseXsltFunctions.getDefaultQualifier("dnet:languages"), values.get("language").listValues()));
            DmfToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("dateofacceptance"), values.get("dateaccepted").listValues());
            DmfToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("publisher"), values.get("publisher").listValues());
            DmfToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("embargoenddate"), values.get("embargoenddate").listValues());
            DmfToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("storagedate"), values.get("storagedate").listValues());
            DmfToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("resulttype"), DmfToHbaseXsltFunctions.getSimpleQualifier("publication", "dnet:result_typologies"));
            DmfToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("fulltext"), values.get("fulltext").listValues());
            if (values.get("concept") != null) {
                for (Element e : values.get("concept")) {
                    String id = e.getAttributes().get("id");
                    if (StringUtils.isBlank((String)id)) {
                        throw new IllegalArgumentException("Context id cannot be blank");
                    }
                    metadata.addContext(ResultProtos.Result.Context.newBuilder().setId(id));
                }
            }
            if (values.get("journal") != null) {
                for (Element e : values.get("journal")) {
                    Map<String, String> attr;
                    ResultProtos.Result.Journal.Builder journal = ResultProtos.Result.Journal.newBuilder();
                    if (e.getText() != null) {
                        journal.setName(e.getText());
                    }
                    if ((attr = e.getAttributes()) != null) {
                        if (attr.get("issn") != null) {
                            journal.setIssnPrinted(attr.get("issn"));
                        }
                        if (attr.get("eissn") != null) {
                            journal.setIssnOnline(attr.get("eissn"));
                        }
                        if (attr.get("lissn") != null) {
                            journal.setIssnLinking(attr.get("lissn"));
                        }
                    }
                    metadata.setJournal(journal.build());
                }
            }
            ResultProtos.Result.Instance.Builder instance = ResultProtos.Result.Instance.newBuilder().setHostedby(DmfToHbaseXsltFunctions.getKV(hostedbyId, hostedbyName));
            DmfToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("licence"), DmfToHbaseXsltFunctions.setQualifier(DmfToHbaseXsltFunctions.getDefaultQualifier("dnet:access_modes"), values.get("accessrights").listValues()));
            DmfToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("instancetype"), DmfToHbaseXsltFunctions.setQualifier(DmfToHbaseXsltFunctions.getDefaultQualifier("dnet:publication_resource"), values.get("cobjcategory").listValues()));
            if (values.get("identifier") != null) {
                DmfToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("url"), Lists.newArrayList((Iterable)Iterables.filter(values.get("identifier").listValues(), (Predicate)urlFilter)));
            }
            result.addInstance(instance);
            ElementList extrefs = values.get("reference");
            if (!extrefs.isEmpty()) {
                Descriptors.Descriptor extDesc = ResultProtos.Result.ExternalReference.getDescriptor();
                for (Element element : extrefs) {
                    ResultProtos.Result.ExternalReference.Builder extref = ResultProtos.Result.ExternalReference.newBuilder();
                    DmfToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("url"), element.getText());
                    DmfToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("sitename"), element.getAttributes().get("source"));
                    DmfToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("refidentifier"), element.getAttributes().get("identifier"));
                    DmfToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("label"), element.getAttributes().get("title"));
                    DmfToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("qualifier"), DmfToHbaseXsltFunctions.setQualifier(DmfToHbaseXsltFunctions.getDefaultQualifier("dnet:externalReference_typologies"), Lists.newArrayList((Object[])new String[]{element.getAttributes().get("type")})).build());
                    result.addExternalReference(extref);
                }
            }
            ArrayList pids = Lists.newArrayList();
            pids.addAll(DmfToHbaseXsltFunctions.parsePids(nodelist));
            pids.add(DmfToHbaseXsltFunctions.getStructuredProperty(originalId, "oai", "oai", "dnet:pid_types", "dnet:pid_types"));
            OafProtos.OafEntity.Builder entity = DmfToHbaseXsltFunctions.getEntity(TypeProtos.Type.result, entityId, DmfToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), originalId, dateOfCollection, pids).setResult(result.setMetadata(metadata));
            OafProtos.Oaf oaf = DmfToHbaseXsltFunctions.getOaf(entity, DmfToHbaseXsltFunctions.getDataInfo(dataInfo, provenanceAction, trust, false, false));
            return DmfToHbaseXsltFunctions.base64(oaf.toByteArray());
        }
        catch (Throwable e) {
            System.err.println("resultId: " + resultId);
            System.err.println("hostedbyId: " + hostedbyId);
            System.err.println("hostedbyName: " + hostedbyName);
            System.err.println("provenanceAction: " + provenanceAction);
            System.err.println("trust: " + trust);
            System.err.println("collectedFromId: " + collectedFromId);
            System.err.println("collectedFromName: " + collectedFromName);
            System.err.println("originalId: " + originalId);
            System.err.println("dateOfCollection: " + dateOfCollection);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

