/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.distance;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.GeneratedMessage;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.distance.AbstractDistance;
import eu.dnetlib.pace.model.Document;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.MapDocument;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ProtoDistance
extends AbstractDistance<GeneratedMessage> {
    private final String identifier;

    public ProtoDistance(String identifier) {
        this.identifier = identifier;
    }

    protected Document toDocument(GeneratedMessage a) {
        HashMap res = Maps.newHashMap();
        ResultProtos.Result.Metadata meta = ((ResultProtos.Result)a).getMetadata();
        if (!meta.getTitleList().isEmpty()) {
            res.put("title", this.transformListSP("title", meta.getTitleList()));
        }
        if (!meta.getDescriptionList().isEmpty()) {
            res.put("description", this.transformListString("description", meta.getDescriptionList()));
        }
        return new MapDocument(this.identifier, (Map)res);
    }

    private List<Field> transformListSP(final String name, List<FieldTypeProtos.StructuredProperty> input) {
        Function<FieldTypeProtos.StructuredProperty, Field> function = new Function<FieldTypeProtos.StructuredProperty, Field>(){

            public Field apply(FieldTypeProtos.StructuredProperty sp) {
                return new Field(Type.String, name, (Object)sp.getValue());
            }
        };
        return Lists.newArrayList((Iterable)Lists.transform(input, (Function)function));
    }

    private List<Field> transformListString(final String name, List<FieldTypeProtos.StringField> input) {
        Function<FieldTypeProtos.StringField, Field> function = new Function<FieldTypeProtos.StringField, Field>(){

            public Field apply(FieldTypeProtos.StringField sp) {
                return new Field(Type.String, name, (Object)StringUtils.substring((String)sp.getValue(), (int)0, (int)100));
            }
        };
        return Lists.newArrayList((Iterable)Lists.transform(input, (Function)function));
    }
}

