/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.sets;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.information.oai.sets.SetCollection;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class MongoSetCollection
implements SetCollection {
    public static String DEFAULT_SET = "OTHER";
    @Autowired
    private Mongo publisherMongoServer;
    private String setCollection = "sets";
    private String setCountCollection = "setsCount";

    public void ensureIndexes(String dbName) {
        this.ensureIndexesOnSets(dbName);
        this.ensureIndexesOnCount(dbName);
    }

    public List<SetInfo> getAllSets(boolean enabledOnly, String dbName) {
        DBCursor cursor = null;
        if (!enabledOnly) {
            cursor = this.getSetsCollection(dbName).find();
        } else {
            BasicDBObject where = new BasicDBObject("enabled", (Object)true);
            cursor = this.getSetsCollection(dbName).find((DBObject)where);
        }
        ArrayList res = Lists.newArrayList();
        while (cursor.hasNext()) {
            DBObject obj = cursor.next();
            res.add(this.getSetFromDBObject(obj));
        }
        return res;
    }

    public boolean containSet(String set, String dbName) {
        BasicDBObject query = new BasicDBObject("spec", (Object)set);
        return this.getSetsCollection(dbName).find((DBObject)query).limit(1).size() != 0;
    }

    public boolean containEnabledSet(String set, String publisherDBName) {
        BasicDBObject query = new BasicDBObject("spec", (Object)set).append("enabled", (Object)true);
        return this.getSetsCollection(publisherDBName).find((DBObject)query).limit(1).size() != 0;
    }

    public String getSetQuery(String set, String dbName) {
        BasicDBObject query = new BasicDBObject("spec", (Object)set);
        BasicDBObject returnField = new BasicDBObject("query", (Object)1);
        DBObject obj = this.getSetsCollection(dbName).findOne((DBObject)query, (DBObject)returnField);
        return (String)obj.get("query");
    }

    public int count(String setSpec, String mdPrefix, String dbName) {
        DBObject query = BasicDBObjectBuilder.start((String)"spec", (Object)setSpec).add("mdPrefix", (Object)mdPrefix).get();
        BasicDBObject returnField = new BasicDBObject("count", (Object)1);
        DBObject obj = this.getSetsCountCollection(dbName).findOne(query, (DBObject)returnField);
        if (obj == null) {
            return 0;
        }
        return (Integer)obj.get("count");
    }

    public void updateCounts(String setSpec, String mdPrefix, int count, String dbName) {
        DBObject setCount = BasicDBObjectBuilder.start((String)"spec", (Object)setSpec).add("mdPrefix", (Object)mdPrefix).get();
        this.getSetsCountCollection(dbName).update(setCount, (DBObject)new BasicDBObject("$set", (Object)new BasicDBObject("count", (Object)count)), true, false);
    }

    public void upsertSet(SetInfo setInfo, boolean fromConfiguration, String dbName) {
        DBObject obj = this.getObjectFromSet(setInfo);
        obj.put("fromConfiguration", (Object)fromConfiguration);
        this.getSetsCollection(dbName).update((DBObject)new BasicDBObject("spec", (Object)setInfo.getSetSpec()), obj, true, false);
    }

    public String normalizeSetSpec(String setName) {
        String s = StringEscapeUtils.unescapeXml((String)setName);
        s = Normalizer.normalize(s, Normalizer.Form.NFD);
        s = s.replaceAll(" ", "_");
        s = s.replaceAll("[\\p{InCombiningDiacriticalMarks}&&[^-_]]", "");
        s = s.replaceAll("[\\p{Punct}&&[^-_]]", "_");
        String stripped = StringUtils.strip((String)(s = s.replaceAll("[\\W&&[^-_]]", "")), (String)"_ ");
        if (StringUtils.isBlank((String)stripped)) {
            stripped = DEFAULT_SET;
        }
        return stripped;
    }

    public List<SetInfo> getConfiguredSets(String dbName) {
        BasicDBObject query = new BasicDBObject("fromConfiguration", (Object)true);
        return this.findSets((DBObject)query, dbName);
    }

    public List<SetInfo> getSetsFromData(String dbName) {
        BasicDBObject query = new BasicDBObject("fromConfiguration", (Object)false);
        return this.findSets((DBObject)query, dbName);
    }

    public void dropOAISets(String dbName) {
        this.getSetsCountCollection(dbName).drop();
        this.getSetsCollection(dbName).drop();
    }

    public void dropSet(String dbName, String setSpec) {
        DBObject query = BasicDBObjectBuilder.start((String)"spec", (Object)setSpec).get();
        this.getSetsCollection(dbName).remove(query);
        this.getSetsCountCollection(dbName).remove(query);
    }

    public void dropConfigurationSets(String dbName) {
        this.getSetsCollection(dbName).remove((DBObject)new BasicDBObject("fromConfiguration", (Object)true));
    }

    protected List<SetInfo> findSets(DBObject query, String dbName) {
        DBCursor cursor = this.getSetsCollection(dbName).find(query);
        ArrayList res = Lists.newArrayList();
        while (cursor.hasNext()) {
            DBObject obj = cursor.next();
            res.add(this.getSetFromDBObject(obj));
        }
        return res;
    }

    private SetInfo getSetFromDBObject(DBObject obj) {
        SetInfo setInfo = new SetInfo();
        setInfo.setEnabled(((Boolean)obj.get("enabled")).booleanValue());
        setInfo.setQuery((String)obj.get("query"));
        setInfo.setSetDescription((String)obj.get("description"));
        setInfo.setSetName((String)obj.get("name"));
        setInfo.setSetSpec((String)obj.get("spec"));
        return setInfo;
    }

    private DBObject getObjectFromSet(SetInfo s) {
        DBObject obj = BasicDBObjectBuilder.start((String)"spec", (Object)s.getSetSpec()).add("name", (Object)s.getSetName()).add("description", (Object)s.getSetDescription()).add("query", (Object)s.getQuery()).add("enabled", (Object)s.isEnabled()).get();
        return obj;
    }

    private void ensureIndexesOnSets(String dbName) {
        BasicDBObject onBackground = new BasicDBObject("background", (Object)true);
        this.getSetsCollection(dbName).createIndex((DBObject)new BasicDBObject("spec", (Object)1), (DBObject)onBackground);
        this.getSetsCollection(dbName).createIndex((DBObject)new BasicDBObject("fromConfiguration", (Object)1), (DBObject)onBackground);
    }

    private void ensureIndexesOnCount(String dbName) {
        DBObject index = BasicDBObjectBuilder.start((String)"spec", (Object)1).add("mdPrefix", (Object)1).get();
        this.getSetsCountCollection(dbName).createIndex(index, (DBObject)new BasicDBObject("background", (Object)true));
    }

    public DBCollection getSetsCollection(String dbName) {
        return this.getCollection(this.setCollection, dbName);
    }

    public DBCollection getSetsCountCollection(String dbName) {
        return this.getCollection(this.setCountCollection, dbName);
    }

    private DBCollection getCollection(String collectionName, String dbName) {
        return this.publisherMongoServer.getDB(dbName).getCollection(collectionName);
    }

    public String getSetCollection() {
        return this.setCollection;
    }

    public void setSetCollection(String setCollection) {
        this.setCollection = setCollection;
    }

    public String getSetCountCollection() {
        return this.setCountCollection;
    }

    public void setSetCountCollection(String setCountCollection) {
        this.setCountCollection = setCountCollection;
    }

    public Mongo getPublisherMongoServer() {
        return this.publisherMongoServer;
    }

    public void setPublisherMongoServer(Mongo publisherMongoServer) {
        this.publisherMongoServer = publisherMongoServer;
    }
}

