/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.mongo;

import com.google.common.collect.Sets;
import com.mongodb.DBObject;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.info.RecordInfo;
import eu.dnetlib.data.oai.store.mongo.MetadataExtractor;
import eu.dnetlib.data.oai.store.mongo.ProvenanceExtractor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class RecordInfoGenerator {
    @Resource
    private MetadataExtractor metadataExtractor;
    @Resource
    private ProvenanceExtractor provenanceExtractor;

    public RecordInfo transformDBObject(DBObject object, boolean includeBody) {
        if (object == null || object.keySet().isEmpty()) {
            return null;
        }
        String id = (String)object.get("objIdentifier");
        id = StringEscapeUtils.escapeXml((String)id);
        boolean deleted = (Boolean)object.get("deleted");
        RecordInfo record = new RecordInfo();
        record.setIdentifier(id);
        record.setInternalId(object.get("_id").toString());
        record.setDatestamp((Date)object.get("datestamp"));
        record.setDeleted(deleted);
        List sets = (List)object.get("set");
        if (sets != null) {
            record.setSetspecs((Set)Sets.newHashSet((Iterable)sets));
        }
        if (includeBody && !deleted) {
            String body = this.decompressRecord((byte[])object.get("body"));
            SAXReader reader = new SAXReader();
            try {
                Document doc = reader.read((Reader)new StringReader(body));
                record.setMetadata(this.metadataExtractor.evaluate(doc));
                record.setProvenance(this.provenanceExtractor.evaluate(doc));
            }
            catch (DocumentException e) {
                throw new OaiPublisherRuntimeException((Throwable)e);
            }
        }
        return record;
    }

    public String decompressRecord(byte[] input) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(input);
            ZipInputStream zis = new ZipInputStream(bis);
            ZipEntry ze = zis.getNextEntry();
            if (ze == null) {
                throw new OaiPublisherRuntimeException("cannot decompress null zip entry ");
            }
            if (!ze.getName().equals("body")) {
                throw new OaiPublisherRuntimeException("cannot decompress zip entry name :" + ze.getName());
            }
            return IOUtils.toString((InputStream)zis);
        }
        catch (IOException e) {
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
    }

    public MetadataExtractor getMetadataExtractor() {
        return this.metadataExtractor;
    }

    public void setMetadataExtractor(MetadataExtractor metadataExtractor) {
        this.metadataExtractor = metadataExtractor;
    }

    public ProvenanceExtractor getProvenanceExtractor() {
        return this.provenanceExtractor;
    }

    public void setProvenanceExtractor(ProvenanceExtractor provenanceExtractor) {
        this.provenanceExtractor = provenanceExtractor;
    }
}

