/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.mongo;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.PublisherStoreDAO;
import eu.dnetlib.data.oai.store.RecordChangeDetector;
import eu.dnetlib.data.oai.store.mongo.MetadataExtractor;
import eu.dnetlib.data.oai.store.mongo.MongoCursor;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.RecordInfoGenerator;
import eu.dnetlib.data.oai.store.parser.MongoQueryParser;
import eu.dnetlib.data.oai.store.sets.MongoSetCollection;
import eu.dnetlib.miscutils.cache.EhCache;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class MongoPublisherStoreDAO
implements PublisherStoreDAO<MongoPublisherStore, MongoCursor> {
    private static final Log log = LogFactory.getLog(MongoPublisherStoreDAO.class);
    @Autowired
    private Mongo publisherMongoServer;
    private String metadataCollection;
    @Resource
    private RecordInfoGenerator recordInfoGenerator;
    @Resource
    private MetadataExtractor metadataExtractor;
    @Resource
    private MongoQueryParser queryParser;
    @Resource(name="oaiConfigurationExistReader")
    private OAIConfigurationReader configuration;
    @Resource
    private RecordChangeDetector recordChangeDetector;
    @Resource
    private MongoSetCollection mongoSetCollection;
    @Resource
    private EhCache<String, MongoPublisherStore> mongoOaistoreCache;
    @Resource
    private EhCache<String, MongoPublisherStore> mongoOaistoreCacheByMdPrefix;
    private boolean alwaysNewRecord;

    protected DB getDB(String dbName) {
        return this.publisherMongoServer.getDB(dbName);
    }

    @Override
    public List<MongoPublisherStore> listPublisherStores(String dbName) {
        ArrayList stores = Lists.newArrayList();
        DB db = this.getDB(dbName);
        DBCursor cursor = db.getCollection(this.metadataCollection).find();
        for (DBObject storeInfo : cursor) {
            stores.add(this.createFromDBObject(storeInfo, db));
        }
        return stores;
    }

    @Override
    public MongoPublisherStore getStore(String storeId, String dbName) {
        DBObject storeInfo = this.getDB(dbName).getCollection(this.metadataCollection).findOne((DBObject)new BasicDBObject("id", (Object)storeId));
        return this.createFromDBObject(storeInfo, this.getDB(dbName));
    }

    @Override
    public MongoPublisherStore getStore(String mdfName, String mdfInterpretation, String mdfLayout, String dbName) {
        return this.getStore(this.generateStoreId(mdfName, mdfInterpretation, mdfLayout), dbName);
    }

    @Override
    public MongoPublisherStore getStoreFor(String targetMetadataPrefix, String dbName) {
        if (this.mongoOaistoreCacheByMdPrefix.containsKey((Object)targetMetadataPrefix)) {
            return (MongoPublisherStore)this.mongoOaistoreCacheByMdPrefix.get((Object)targetMetadataPrefix);
        }
        MDFInfo info = this.configuration.getMetadataFormatInfo(targetMetadataPrefix);
        MongoPublisherStore store = this.getStore(info.getSourceFormatName(), info.getSourceFormatInterpretation(), info.getSourceFormatLayout(), dbName);
        this.mongoOaistoreCacheByMdPrefix.put((Object)targetMetadataPrefix, (Object)store);
        return store;
    }

    @Override
    public MongoPublisherStore createStore(String mdfName, String mdfInterpretation, String mdfLayout, String dbName) throws OaiPublisherException {
        DB db = this.getDB(dbName);
        DBObject store = this.createMetadataEntry(mdfName, mdfInterpretation, mdfLayout);
        DBCollection metadata = db.getCollection(this.metadataCollection);
        metadata.insert(new DBObject[]{store});
        MongoPublisherStore theStore = this.createFromDBObject(store, db);
        return theStore;
    }

    @Override
    public boolean deleteStore(String storeId, String dbName) {
        DB db = this.getDB(dbName);
        DBCollection metadata = db.getCollection(this.metadataCollection);
        DBObject storeInfo = metadata.findOne((DBObject)new BasicDBObject("id", (Object)storeId));
        if (storeInfo == null) {
            return false;
        }
        db.getCollection(storeId).drop();
        metadata.remove(storeInfo);
        this.mongoSetCollection.dropOAISets(dbName);
        log.debug((Object)("Deleted oaistore " + storeId + ", db: " + dbName));
        return true;
    }

    @Override
    public boolean deleteFromStore(String storeId, String dbName, String set) {
        DB db = this.getDB(dbName);
        DBCollection metadata = db.getCollection(this.metadataCollection);
        DBObject storeInfo = metadata.findOne((DBObject)new BasicDBObject("id", (Object)storeId));
        if (storeInfo == null) {
            return false;
        }
        db.getCollection(storeId).remove((DBObject)new BasicDBObject("set", (Object)set));
        this.mongoSetCollection.dropSet(dbName, set);
        log.debug((Object)("Deleted set " + set + " from oaistore " + storeId + ", db: " + dbName));
        return true;
    }

    @Override
    public boolean deleteFromStore(String mdfName, String mdfInterpretation, String mdfLayout, String dbName, String set) {
        return this.deleteFromStore(this.generateStoreId(mdfName, mdfInterpretation, mdfLayout), dbName, set);
    }

    @Override
    public boolean deleteStore(String mdfName, String mdfInterpretation, String mdfLayout, String dbName) {
        return this.deleteStore(this.generateStoreId(mdfName, mdfInterpretation, mdfLayout), dbName);
    }

    public void ensureIndex(final MongoPublisherStore store) {
        if (store == null) {
            throw new OaiPublisherRuntimeException("Can't ensure index on null store");
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                store.ensureIndices();
            }
        };
        t.start();
    }

    public void ensureIndex(String dbName) {
        List<MongoPublisherStore> stores = this.listPublisherStores(dbName);
        for (MongoPublisherStore s : stores) {
            s.ensureIndices();
        }
    }

    private MongoPublisherStore createFromDBObject(DBObject storeInfo, DB db) {
        if (storeInfo == null) {
            return null;
        }
        String storeId = (String)storeInfo.get("id");
        String mdFormat = (String)storeInfo.get("metadataFormat");
        String mdInterpreation = (String)storeInfo.get("interpretation");
        String mdLayout = (String)storeInfo.get("layout");
        String k = db.getName() + "-" + storeId;
        if (this.mongoOaistoreCache.containsKey((Object)k)) {
            log.debug((Object)("Store retreived from cache and alwaysNewRecord is" + this.alwaysNewRecord));
            MongoPublisherStore store = (MongoPublisherStore)this.mongoOaistoreCache.get((Object)k);
            store.setAlwaysNewRecord(this.alwaysNewRecord);
            return store;
        }
        log.debug((Object)("Store retreived, cache miss,  alwaysNewRecord is" + this.alwaysNewRecord));
        log.fatal((Object)("Not using cache to create oaistore from dbObject: " + k));
        MongoPublisherStore store = new MongoPublisherStore(storeId, mdFormat, mdInterpreation, mdLayout, db.getCollection(storeId), this.configuration.getFields(mdFormat, mdInterpreation, mdLayout), this.queryParser, this.recordInfoGenerator, this.configuration.getIdScheme(), this.configuration.getIdNamespace(), this.metadataExtractor, this.recordChangeDetector, this.alwaysNewRecord);
        store.setMongoSetCollection(this.mongoSetCollection);
        this.mongoOaistoreCache.put((Object)k, (Object)store);
        return store;
    }

    private DBObject createMetadataEntry(String mdfName, String mdfInterpretation, String mdfLayout) {
        DBObject info = BasicDBObjectBuilder.start((String)"id", (Object)this.generateStoreId(mdfName, mdfInterpretation, mdfLayout)).append("metadataFormat", (Object)mdfName).append("interpretation", (Object)mdfInterpretation).append("layout", (Object)mdfLayout).get();
        return info;
    }

    private String generateStoreId(String mdfName, String mdfInterpretation, String mdfLayout) {
        return mdfName + "-" + mdfLayout + "-" + mdfInterpretation;
    }

    public String getMetadataCollection() {
        return this.metadataCollection;
    }

    @Required
    public void setMetadataCollection(String metadataCollection) {
        this.metadataCollection = metadataCollection;
    }

    public MongoQueryParser getQueryParser() {
        return this.queryParser;
    }

    public void setQueryParser(MongoQueryParser queryParser) {
        this.queryParser = queryParser;
    }

    public OAIConfigurationReader getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OAIConfigurationReader configuration) {
        this.configuration = configuration;
    }

    public RecordInfoGenerator getRecordInfoGenerator() {
        return this.recordInfoGenerator;
    }

    public void setRecordInfoGenerator(RecordInfoGenerator recordInfoGenerator) {
        this.recordInfoGenerator = recordInfoGenerator;
    }

    public MetadataExtractor getMetadataExtractor() {
        return this.metadataExtractor;
    }

    public void setMetadataExtractor(MetadataExtractor metadataExtractor) {
        this.metadataExtractor = metadataExtractor;
    }

    public RecordChangeDetector getRecordChangeDetector() {
        return this.recordChangeDetector;
    }

    public void setRecordChangeDetector(RecordChangeDetector recordChangeDetector) {
        this.recordChangeDetector = recordChangeDetector;
    }

    public MongoSetCollection getMongoSetCollection() {
        return this.mongoSetCollection;
    }

    public void setMongoSetCollection(MongoSetCollection mongoSetCollection) {
        this.mongoSetCollection = mongoSetCollection;
    }

    public Mongo getPublisherMongoServer() {
        return this.publisherMongoServer;
    }

    public void setPublisherMongoServer(Mongo publisherMongoServer) {
        this.publisherMongoServer = publisherMongoServer;
    }

    public boolean isAlwaysNewRecord() {
        return this.alwaysNewRecord;
    }

    public void setAlwaysNewRecord(boolean alwaysNewRecord) {
        this.alwaysNewRecord = alwaysNewRecord;
    }
}

