package eu.dnetlib.msro.workflows.nodes.mdstore;

import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;

// TODO: Auto-generated Javadoc
/**
 * The Class MultipleMdStoreIterator.
 */
public class MultipleMdStoreIterator implements Iterator<String> {

	private static final Log log = LogFactory.getLog(MultipleMdStoreIterator.class); // NOPMD by marko on 11/24/08 5:02 PM

	/** The service locator. */
	@Resource
	private UniqueServiceLocator serviceLocator;

	/** The md i ds. */
	private List<String> mdIDs;

	/** The current id. */
	private String currentId = null;

	/** The current iterator. */
	private Iterator<String> currentIterator;

	/** The result set client factory. */
	@Autowired
	private ResultSetClientFactory resultSetClientFactory;

	/**
	 * Instantiates a new multiple md store iterator.
	 *
	 * @param mdstoreLocator
	 *            the mdstore locator
	 * @param mdIds
	 *            the md ids
	 */
	public MultipleMdStoreIterator(final UniqueServiceLocator serviceLocator, final List<String> mdIds, final ResultSetClientFactory resultSetClientFactory) {
		this.serviceLocator = serviceLocator;
		this.mdIDs = mdIds;
		this.resultSetClientFactory = resultSetClientFactory;
		getNextMDStoreRecords();

	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.util.Iterator#hasNext()
	 */
	@Override
	public boolean hasNext() {
		if ((currentId == null) || (currentIterator == null)) return false;
		return currentIterator.hasNext();
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.util.Iterator#next()
	 */
	@Override
	public String next() {
		String nextElement = currentIterator.next();
		if (!currentIterator.hasNext()) {
			getNextMDStoreRecords();
		}
		return nextElement;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.util.Iterator#remove()
	 */
	@Override
	public void remove() {
		currentIterator.remove();
	}

	/**
	 * Gets the next md store records.
	 *
	 * @return the next md store records
	 */
	private void getNextMDStoreRecords() {
		if (mdIDs.size() > 0) {
			currentId = mdIDs.remove(0);
			currentIterator = getIterableResultset(currentId);
		}
	}

	/**
	 * Gets the iterable resultset.
	 *
	 * @param id
	 *            the id
	 * @return the iterable resultset
	 */
	private Iterator<String> getIterableResultset(final String id) {
		log.debug(String.format("iterating over mdId '%s'", id));
		try {
			W3CEndpointReference epr = serviceLocator.getService(MDStoreService.class, id).deliverMDRecords(id, "", "", "");
			Iterable<String> input = resultSetClientFactory.getClient(epr);
			return input.iterator();
		} catch (MDStoreServiceException e) {
			log.error(e);
			return null;
		}
	}
}
