package eu.dnetlib.msro.workflows.nodes.mdstore;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class FetchMDStoreRecordsJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(FetchMDStoreRecordsJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource
	private UniqueServiceLocator serviceLocator;

	private String mdId;
	private String mdFormat;
	private String eprParam;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		if (getMdId() == null) {
			setMdId(token.getEnv().getAttribute("mdId"));
		}
		if (getMdFormat() == null) {
			setMdFormat(token.getEnv().getAttribute("mdFormat"));
		}

		log.info("getting MDRecords from: " + getMdId());
		final W3CEndpointReference epr = serviceLocator.getService(MDStoreService.class, getMdId()).deliverMDRecords(getMdId(), "", "", "");
		if (epr == null) { throw new MSROException("unable to read MDRecords from: " + getMdId()); }
		token.getEnv().setAttribute(getEprParam(), epr.toString());
		return Arc.DEFAULT_ARC;
	}

	public String getMdId() {
		return mdId;
	}

	public void setMdId(final String mdId) {
		this.mdId = mdId;
	}

	public String getMdFormat() {
		return mdFormat;
	}

	public void setMdFormat(final String mdFormat) {
		this.mdFormat = mdFormat;
	}

	public String getEprParam() {
		return eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}
}
