package eu.dnetlib.msro.workflows.nodes.info;

import java.io.StringReader;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import org.apache.cxf.common.util.StringUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class RemoveApiExtraFieldsJobNode extends SimpleJobNode {

	private String datasourceId;
	private String datasourceInterface;
	private String fields;

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		if (!StringUtils.isEmpty(fields)) {
			final Set<String> invalidFields = Sets.newHashSet(Splitter.on(",").omitEmptyStrings().trimResults().split(fields.toLowerCase()));
			final Map<String, String> map = calculateValidExtraFields(datasourceId, datasourceInterface, invalidFields);
			serviceLocator.getService(DatasourceManagerService.class).bulkUpdateApiExtraFields(datasourceId, datasourceInterface, map);
		}
		return Arc.DEFAULT_ARC;
	}

	private Map<String, String> calculateValidExtraFields(final String repoId, final String ifaceId, final Set<String> invalidFields) throws Exception {
		final Map<String, String> res = Maps.newHashMap();

		final String profile = serviceLocator.getService(ISLookUpService.class).getResourceProfile(repoId);

		final SAXReader reader = new SAXReader();
		final Document doc = reader.read(new StringReader(profile));

		final Node ifcNode = doc.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']");
		if (ifcNode != null) {
			for (Object o : ifcNode.selectNodes("./INTERFACE_EXTRA_FIELD")) {
				final String name = ((Node) o).valueOf("@name");
				if (!invalidFields.contains(name.toLowerCase())) {
					res.put(name, ((Node) o).getText());
				}
			}
		}

		return res;
	}

	public String getFields() {
		return fields;
	}

	public void setFields(final String fields) {
		this.fields = fields;
	}

	public String getDatasourceId() {
		return datasourceId;
	}

	public void setDatasourceId(final String datasourceId) {
		this.datasourceId = datasourceId;
	}

	public String getDatasourceInterface() {
		return datasourceInterface;
	}

	public void setDatasourceInterface(final String datasourceInterface) {
		this.datasourceInterface = datasourceInterface;
	}

}
