package eu.dnetlib.msro.workflows.nodes.info;

import java.io.StringReader;
import java.util.Map;

import javax.annotation.Resource;

import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class ObjectStoreToApiExtraFieldJobNode extends SimpleJobNode {

	private String objId;
	private String datasourceId;
	private String datasourceInterface;
	private String extraFieldForTotal;
	private String extraFieldForDate;
	private String extraFieldForObjId;

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final String xq = "for $x in collection('/db/DRIVER/ObjectStoreDSResources/ObjectStoreDSResourceType') " + "where $x//RESOURCE_IDENTIFIER/@value='"
				+ objId + "' " + "return concat($x//COUNT_STORE, ' @=@ ', $x//LAST_STORAGE_DATE)";

		final String s = serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(xq);

		final String[] arr = s.split(" @=@ ");

		final Map<String, String> map = getCurrentExtraFields(datasourceId, datasourceInterface);
		map.put(extraFieldForTotal, arr[0].trim());
		map.put(extraFieldForDate, arr[1].trim());
		map.put(extraFieldForObjId, objId);

		serviceLocator.getService(DatasourceManagerService.class).bulkUpdateApiExtraFields(datasourceId, datasourceInterface, map);

		return Arc.DEFAULT_ARC;
	}

	private Map<String, String> getCurrentExtraFields(final String repoId, final String ifaceId) throws Exception {
		final Map<String, String> res = Maps.newHashMap();

		final String profile = serviceLocator.getService(ISLookUpService.class).getResourceProfile(repoId);

		final SAXReader reader = new SAXReader();
		final Document doc = reader.read(new StringReader(profile));

		final Node ifcNode = doc.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']");
		if (ifcNode != null) {
			for (Object o : ifcNode.selectNodes("./INTERFACE_EXTRA_FIELD")) {
				res.put(((Node) o).valueOf("@name"), ((Node) o).getText());
			}
		}

		return res;
	}

	public String getDatasourceId() {
		return datasourceId;
	}

	public void setDatasourceId(final String datasourceId) {
		this.datasourceId = datasourceId;
	}

	public String getDatasourceInterface() {
		return datasourceInterface;
	}

	public void setDatasourceInterface(final String datasourceInterface) {
		this.datasourceInterface = datasourceInterface;
	}

	public String getExtraFieldForTotal() {
		return extraFieldForTotal;
	}

	public void setExtraFieldForTotal(final String extraFieldForTotal) {
		this.extraFieldForTotal = extraFieldForTotal;
	}

	public String getExtraFieldForDate() {
		return extraFieldForDate;
	}

	public void setExtraFieldForDate(final String extraFieldForDate) {
		this.extraFieldForDate = extraFieldForDate;
	}

	/**
	 * @return the objId
	 */
	public String getObjId() {
		return objId;
	}

	/**
	 * @param objId
	 *            the objId to set
	 */
	public void setObjId(final String objId) {
		this.objId = objId;
	}

	/**
	 * @return the extraFieldForObjId
	 */
	public String getExtraFieldForObjId() {
		return extraFieldForObjId;
	}

	/**
	 * @param extraFieldForObjId
	 *            the extraFieldForObjId to set
	 */
	public void setExtraFieldForObjId(final String extraFieldForObjId) {
		this.extraFieldForObjId = extraFieldForObjId;
	}

}
