package eu.dnetlib.msro.workflows.nodes.download;

import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;

import eu.dnetlib.data.download.rmi.DownloadService;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

// TODO: Auto-generated Javadoc
/**
 * The Class DownloadFromMetadata is a job node that send a blackboard message to the Download service to start to download file from url
 * retrieved by Metadata .
 */
public class DownloadFromMetadataJobNode extends BlackboardJobNode implements ProgressJobNode {

	/** The inputepr param. */
	private String inputeprParam;

	/** The obejct store id. */
	private String objectStoreID;

	/** The plugin. */
	private String plugin;

	/** The protocol. */
	private String protocol;

	/** The mime type. */
	private String mimeType;

	protected String regularExpression;

	/** The process counting result set factory. */
	@Autowired
	private ProcessCountingResultSetFactory processCountingResultSetFactory;

	/** The progress provider. */
	private ResultsetProgressProvider progressProvider;

	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.msro.workflows.nodes.BlackboardJobNode#obtainServiceId(com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected String obtainServiceId(final NodeToken token) {
		return getServiceLocator().getServiceId(DownloadService.class);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.msro.workflows.nodes.BlackboardJobNode#prepareJob(eu.dnetlib.enabling.tools.blackboard.BlackboardJob,
	 * com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		job.setAction("DOWNLOAD");
		final String eprS = token.getEnv().getAttribute(getInputeprParam());
		this.progressProvider = processCountingResultSetFactory.createProgressProvider(token.getProcess(), eprS);
		job.getParameters().put("epr", progressProvider.getEpr().toString());
		job.getParameters().put("protocol", getProtocol());
		job.getParameters().put("plugin", getPlugin());
		job.getParameters().put("mimeType", getMimeType());
		job.getParameters().put("objectStoreID", getObjectStoreID());

		if (!StringUtils.isEmpty(getRegularExpression())){
			job.getParameters().put("regularExpressions", getRegularExpression());
		}


	}

	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.msro.workflows.nodes.BlackboardJobNode#generateBlackboardListener(com.googlecode.sarasvati.Engine,
	 * com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected BlackboardWorkflowJobListener generateBlackboardListener(final Engine engine, final NodeToken token) {
		return new BlackboardWorkflowJobListener(engine, token) {

			@Override
			protected void populateEnv(final Env env, final Map<String, String> responseParams) {
				env.setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "total", responseParams.get("total"));
			}
		};
	}

	/**
	 * Gets the inputepr param.
	 *
	 * @return the inputeprParam
	 */
	public String getInputeprParam() {
		return inputeprParam;
	}

	/**
	 * Gets the object store id.
	 *
	 * @return the objectStoreID
	 */
	public String getObjectStoreID() {
		return objectStoreID;
	}

	/**
	 * Sets the object store id.
	 *
	 * @param objectStoreID
	 *            the objectStoreID to set
	 */
	public void setObjectStoreID(final String objectStoreID) {
		this.objectStoreID = objectStoreID;
	}

	/**
	 * Gets the plugin.
	 *
	 * @return the plugin
	 */
	public String getPlugin() {
		return plugin;
	}

	/**
	 * Sets the plugin.
	 *
	 * @param plugin
	 *            the plugin to set
	 */
	public void setPlugin(final String plugin) {
		this.plugin = plugin;
	}

	/**
	 * Gets the protocol.
	 *
	 * @return the protol
	 */
	public String getProtocol() {
		return protocol;
	}

	/**
	 * Sets the protocol.
	 *
	 * @param protol
	 *            the protol to set
	 */
	public void setProtocol(final String protol) {
		this.protocol = protol;
	}

	/**
	 * Gets the mime type.
	 *
	 * @return the mimeType
	 */
	public String getMimeType() {
		return mimeType;
	}

	/**
	 * Sets the mime type.
	 *
	 * @param mimeType
	 *            the mimeType to set
	 */
	public void setMimeType(final String mimeType) {
		this.mimeType = mimeType;
	}

	/**
	 * Sets the inputepr param.
	 *
	 * @param inputeprParam
	 *            the inputeprParam to set
	 */
	public void setInputeprParam(final String inputeprParam) {
		this.inputeprParam = inputeprParam;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.msro.workflows.nodes.ProgressJobNode#getProgressProvider()
	 */
	@Override
	public ProgressProvider getProgressProvider() {
		return progressProvider;
	}

	public String getRegularExpression() {
		return regularExpression;
	}

	public void setRegularExpression(final String regularExpression) {
		this.regularExpression = regularExpression;
	}

}
