package eu.dnetlib.msro.workflows.nodes.collect;

import java.io.StringReader;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.collector.rmi.CollectorService;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class DateRangeCollectRecordsJobNode extends SimpleJobNode {

	@Resource
	private UniqueServiceLocator serviceLocator;

	private String datasourceId;
	private String datasourceInterface;
	private String eprParam;
	private String fromDateParam;
	private String untilDateParam;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final String profile = serviceLocator.getService(ISLookUpService.class).getResourceProfile(datasourceId);
		final Document doc = new SAXReader().read(new StringReader(profile));
		final Node ifcNode = doc.selectSingleNode("//INTERFACE[@id='" + datasourceInterface + "']");
		final String fromDate = token.getEnv().getAttribute(getFromDateParam());
		final String untilDate = token.getEnv().getAttribute(getUntilDateParam());

		final InterfaceDescriptor interfaceDescriptor = InterfaceDescriptor.newInstance(ifcNode);

		final W3CEndpointReference epr = serviceLocator.getService(CollectorService.class).dateRangeCollect(interfaceDescriptor, fromDate, untilDate);

		token.getEnv().setAttribute(getEprParam(), epr.toString());

		return Arc.DEFAULT_ARC;
	}

	public String getFromDateParam() {
		return fromDateParam;
	}

	public void setFromDateParam(final String fromDateParam) {
		this.fromDateParam = fromDateParam;
	}

	public String getUntilDateParam() {
		return untilDateParam;
	}

	public void setUntilDateParam(final String untilDateParam) {
		this.untilDateParam = untilDateParam;
	}

	public String getDatasourceId() {
		return datasourceId;
	}

	public void setDatasourceId(final String datasourceId) {
		this.datasourceId = datasourceId;
	}

	public String getDatasourceInterface() {
		return datasourceInterface;
	}

	public void setDatasourceInterface(final String datasourceInterface) {
		this.datasourceInterface = datasourceInterface;
	}

	public String getEprParam() {
		return eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

}
