package eu.dnetlib.data.collector.plugins.httplist;

import java.util.Iterator;

import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;

public class HttpListCollectorPlugin extends AbstractCollectorPlugin {

	@Override
	public Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor, final String fromDate, final String untilDate)
			throws CollectorServiceException {
		final String baseUrl = interfaceDescriptor.getBaseUrl();
		final String listAddress = interfaceDescriptor.getParams().get("listUrl");

		return new Iterable<String>() {

			@Override
			public Iterator<String> iterator() {
				return new HttpListIterator(baseUrl, listAddress);
			}
		};
	}
}
