/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HttpCSVCollectorPlugin
extends AbstractCollectorPlugin {
    private static final Log log = LogFactory.getLog(HttpCSVCollectorPlugin.class);

    public Iterable<String> collect(InterfaceDescriptor descriptor, String fromDate, String untilDate) throws CollectorServiceException {
        return new HTTPCSVIterator(descriptor);
    }

    class HTTPCSVIterator
    implements Iterable<String> {
        private InterfaceDescriptor descriptor;

        public HTTPCSVIterator(InterfaceDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public Iterator<String> iterator() {
            try {
                String separatorString = (String)this.descriptor.getParams().get("separator");
                final String identifier = (String)this.descriptor.getParams().get("identifier");
                String quote = (String)this.descriptor.getParams().get("quote");
                URL url = new URL(this.descriptor.getBaseUrl());
                url.openConnection();
                InputStreamReader reader = new InputStreamReader(url.openStream());
                char separator = separatorString.equals("\\t") || StringUtils.isBlank((String)separatorString) ? (char)'\t' : (char)separatorString.charAt(0);
                CSVFormat format = StringUtils.isBlank((String)quote) ? CSVFormat.EXCEL.withHeader(new String[0]).withDelimiter(separator).withQuote(null) : CSVFormat.EXCEL.withHeader(new String[0]).withDelimiter(separator).withQuote(quote.charAt(0));
                CSVParser parser = new CSVParser((Reader)reader, format.withTrim());
                final Set headers = parser.getHeaderMap().keySet();
                return Iterators.transform((Iterator)parser.iterator(), (Function)new Function<CSVRecord, String>(){

                    public String apply(CSVRecord input) {
                        Document document = DocumentHelper.createDocument();
                        Element root = document.addElement("csvRecord");
                        for (String key : headers) {
                            Element row = root.addElement("column");
                            row.addAttribute("name", key).addText(input.get(key));
                            if (!key.equals(identifier)) continue;
                            row.addAttribute("isID", "true");
                        }
                        return document.asXML();
                    }
                });
            }
            catch (Exception e) {
                log.error((Object)"Error iterating csv lines", (Throwable)e);
                return null;
            }
        }
    }
}

