/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins;

import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FileCSVCollectorPlugin
extends AbstractCollectorPlugin {
    private static final Log log = LogFactory.getLog(FileCSVCollectorPlugin.class);
    private String[] headers = null;
    private int identifierNumber;

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        String header = (String)interfaceDescriptor.getParams().get("header");
        final String separator = StringEscapeUtils.unescapeJava((String)((String)interfaceDescriptor.getParams().get("separator")));
        final String quote = (String)interfaceDescriptor.getParams().get("quote");
        this.identifierNumber = Integer.parseInt((String)interfaceDescriptor.getParams().get("identifier"));
        URL u = null;
        try {
            u = new URL(interfaceDescriptor.getBaseUrl());
        }
        catch (MalformedURLException e1) {
            throw new CollectorServiceException((Throwable)e1);
        }
        String baseUrl = u.getPath();
        log.info((Object)("base URL = " + baseUrl));
        try {
            final BufferedReader br = new BufferedReader(new FileReader(new File(baseUrl)));
            if (header != null && "true".equals(header.toLowerCase())) {
                String[] tmpHeader = br.readLine().split(separator);
                if (StringUtils.isNotBlank((String)quote)) {
                    int i = 0;
                    this.headers = new String[tmpHeader.length];
                    for (String h : tmpHeader) {
                        this.headers[i] = StringUtils.strip((String)h, (String)quote);
                        ++i;
                    }
                } else {
                    this.headers = tmpHeader;
                }
            }
            return new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return new FileCSVIterator(br, separator, quote);
                }
            };
        }
        catch (Exception e) {
            throw new CollectorServiceException((Throwable)e);
        }
    }

    class FileCSVIterator
    implements Iterator<String> {
        private String next;
        private BufferedReader reader;
        private String separator;
        private String quote;

        public FileCSVIterator(BufferedReader reader, String separator, String quote) {
            this.reader = reader;
            this.separator = separator;
            this.quote = quote;
            this.next = this.calculateNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            String s = this.next;
            this.next = this.calculateNext();
            return s;
        }

        private String calculateNext() {
            try {
                Document document = DocumentHelper.createDocument();
                Element root = document.addElement("csvRecord");
                String newLine = this.reader.readLine();
                if (newLine == null) {
                    newLine = this.reader.readLine();
                }
                if (newLine == null) {
                    log.info((Object)"there is no line, closing RESULT SET");
                    this.reader.close();
                    return null;
                }
                String[] currentRow = newLine.split(this.separator);
                if (currentRow != null) {
                    for (int i = 0; i < currentRow.length; ++i) {
                        String hAttribute = FileCSVCollectorPlugin.this.headers != null && i < FileCSVCollectorPlugin.this.headers.length ? FileCSVCollectorPlugin.this.headers[i] : "column" + i;
                        Element row = root.addElement("column");
                        if (i == FileCSVCollectorPlugin.this.identifierNumber) {
                            row.addAttribute("isID", "true");
                        }
                        String value = StringUtils.isBlank((String)this.quote) ? currentRow[i] : StringUtils.strip((String)currentRow[i], (String)this.quote);
                        row.addAttribute("name", hAttribute).addText(value);
                    }
                    return document.asXML();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error calculating next csv element", (Throwable)e);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

