/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ftp;

import eu.dnetlib.data.collector.rmi.CollectorServiceRuntimeException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(FtpIterator.class);
    private static final int MAX_RETRIES = 5;
    private static final int DEFAULT_TIMEOUT = 30000;
    private static final long BACKOFF_MILLIS = 10000L;
    private FTPClient ftpClient;
    private String ftpServerAddress;
    private String remoteFtpBasePath;
    private String username;
    private String password;
    private boolean isRecursive;
    private Set<String> extensionsSet;
    private Queue<String> queue;

    public FtpIterator(String baseUrl, String username, String password, boolean isRecursive, Set<String> extensionsSet) {
        this.username = username;
        this.password = password;
        this.isRecursive = isRecursive;
        this.extensionsSet = extensionsSet;
        try {
            URL server = new URL(baseUrl);
            this.ftpServerAddress = server.getHost();
            this.remoteFtpBasePath = server.getPath();
        }
        catch (MalformedURLException e1) {
            throw new CollectorServiceRuntimeException("Malformed URL exception " + baseUrl);
        }
        this.connectToFtpServer();
        this.initializeQueue();
    }

    private void connectToFtpServer() {
        this.ftpClient = new FTPClient();
        this.ftpClient.setDefaultTimeout(30000);
        this.ftpClient.setDataTimeout(30000);
        this.ftpClient.setConnectTimeout(30000);
        try {
            this.ftpClient.connect(this.ftpServerAddress);
            if (!this.ftpClient.login(this.username, this.password)) {
                this.ftpClient.logout();
                throw new CollectorServiceRuntimeException("Unable to login to FTP server " + this.ftpServerAddress);
            }
            int reply = this.ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.ftpClient.disconnect();
                throw new CollectorServiceRuntimeException("Unable to connect to FTP server " + this.ftpServerAddress);
            }
            this.ftpClient.enterLocalPassiveMode();
            log.info((Object)("Connected to FTP server " + this.ftpServerAddress));
            log.info((Object)String.format("FTP collecting from %s with recursion = %s", this.remoteFtpBasePath, this.isRecursive));
        }
        catch (IOException e) {
            throw new CollectorServiceRuntimeException("Unable to connect to FTP server " + this.ftpServerAddress);
        }
    }

    private void disconnectFromFtpServer() {
        try {
            if (this.ftpClient.isConnected()) {
                this.ftpClient.logout();
                this.ftpClient.disconnect();
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed to logout & disconnect from the FTP server", (Throwable)e);
        }
    }

    private void initializeQueue() {
        this.queue = new LinkedList<String>();
        this.listDirectoryRecursive(this.remoteFtpBasePath, "");
    }

    private void listDirectoryRecursive(String parentDir, String currentDir) {
        String dirToList = parentDir;
        if (!currentDir.equals("")) {
            dirToList = dirToList + "/" + currentDir;
        }
        try {
            FTPFile[] subFiles = this.ftpClient.listFiles(dirToList);
            if (subFiles != null && subFiles.length > 0) {
                for (FTPFile aFile : subFiles) {
                    String currentFileName = aFile.getName();
                    if (currentFileName.equals(".") || currentFileName.equals("..")) continue;
                    if (aFile.isDirectory()) {
                        if (!this.isRecursive) continue;
                        this.listDirectoryRecursive(dirToList, currentFileName);
                        continue;
                    }
                    for (String ext : this.extensionsSet) {
                        if (!currentFileName.endsWith(ext)) continue;
                        this.queue.add(dirToList + "/" + currentFileName);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CollectorServiceRuntimeException("Unable to list FTP remote folder", (Throwable)e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.queue.isEmpty()) {
            this.disconnectFromFtpServer();
            return false;
        }
        return true;
    }

    @Override
    public String next() {
        String nextRemotePath = this.queue.remove();
        int nRepeat = 0;
        while (nRepeat < 5) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                if (!this.ftpClient.isConnected()) {
                    this.connectToFtpServer();
                }
                this.ftpClient.retrieveFile(nextRemotePath, (OutputStream)baos);
                log.debug((Object)String.format("Collected file from FTP: %s%s", this.ftpServerAddress, nextRemotePath));
                return baos.toString();
            }
            catch (IOException e) {
                log.warn((Object)String.format("An error occurred [%s] for %s%s, retrying.. [retried %s time(s)]", e.getMessage(), this.ftpServerAddress, nextRemotePath, ++nRepeat));
                this.disconnectFromFtpServer();
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    log.error((Object)e1);
                }
            }
        }
        throw new CollectorServiceRuntimeException(String.format("Impossible to retrieve FTP file %s after %s retries. Aborting FTP collection.", nextRemotePath, nRepeat));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

