/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import eu.dnetlib.data.collector.functions.ParamValuesFunction;
import eu.dnetlib.data.collector.plugins.oaisets.OaiSetsIteratorFactory;
import eu.dnetlib.data.collector.rmi.ProtocolParameterValue;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class ListOaiSetsFunction
implements ParamValuesFunction {
    private OaiSetsIteratorFactory oaiSetsIteratorFactory;

    public List<ProtocolParameterValue> findValues(String baseUrl, Map<String, String> params) {
        final SAXReader reader = new SAXReader();
        Iterator iter = Iterators.transform(this.oaiSetsIteratorFactory.newIterator(baseUrl), (Function)new Function<String, ProtocolParameterValue>(){

            public ProtocolParameterValue apply(String s) {
                try {
                    Document doc = reader.read((Reader)new StringReader(s));
                    String id = doc.valueOf("//*[local-name()='setSpec']");
                    String name = doc.valueOf("//*[local-name()='setName']");
                    return new ProtocolParameterValue(id, name);
                }
                catch (DocumentException e) {
                    throw new RuntimeException("Error in ListSets", e);
                }
            }
        });
        return Lists.newArrayList((Iterator)iter);
    }

    public OaiSetsIteratorFactory getOaiSetsIteratorFactory() {
        return this.oaiSetsIteratorFactory;
    }

    @Required
    public void setOaiSetsIteratorFactory(OaiSetsIteratorFactory oaiSetsIteratorFactory) {
        this.oaiSetsIteratorFactory = oaiSetsIteratorFactory;
    }
}

