/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.dnetlib.data.collector.CollectorPluginEnumerator;
import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorService;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import eu.dnetlib.data.collector.rmi.ProtocolDescriptor;
import eu.dnetlib.data.collector.rmi.ProtocolParameter;
import eu.dnetlib.data.collector.rmi.ProtocolParameterValue;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

public class CollectorServiceImpl
extends AbstractBaseService
implements CollectorService {
    @Resource
    private CollectorPluginEnumerator collectorPluginEnumerator;
    @Resource
    private IterableResultSetFactory iterableResultSetFactory;

    public W3CEndpointReference collect(InterfaceDescriptor ifDescriptor) throws CollectorServiceException {
        return this.dateRangeCollect(ifDescriptor, null, null);
    }

    public W3CEndpointReference dateRangeCollect(InterfaceDescriptor ifDescriptor, String from, String until) throws CollectorServiceException {
        CollectorPlugin plugin = this.collectorPluginEnumerator.get(ifDescriptor.getProtocol());
        if (!this.verifyParams(ifDescriptor.getParams().keySet(), Sets.newHashSet((Iterable)plugin.listNameParameters()))) {
            throw new CollectorServiceException("Invalid parameters, valid: " + plugin.listNameParameters() + ", current: " + ifDescriptor.getParams().keySet());
        }
        Iterable iter = plugin.collect(ifDescriptor, from, until);
        return this.iterableResultSetFactory.createIterableResultSet(iter);
    }

    public List<ProtocolDescriptor> listProtocols() {
        ArrayList list = Lists.newArrayList();
        for (CollectorPlugin plugin : this.collectorPluginEnumerator.getAll()) {
            list.add(plugin.getProtocolDescriptor());
        }
        return list;
    }

    public List<ProtocolParameterValue> listValidValuesForParam(String protocol, String baseUrl, String param, Map<String, String> otherParams) throws CollectorServiceException {
        CollectorPlugin plugin = this.collectorPluginEnumerator.get(protocol);
        for (ProtocolParameter pp : plugin.getProtocolDescriptor().getParams()) {
            if (!pp.getName().equals(param) || !pp.isFunctionPopulated()) continue;
            return pp.getPopulateFunction().findValues(baseUrl, otherParams);
        }
        return Lists.newArrayList();
    }

    private boolean verifyParams(Set<String> curr, Set<String> valid) {
        return valid.containsAll(curr);
    }
}

