/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.index;

import eu.dnetlib.functionality.index.solr.feed.ResultTransformer;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;

public class ResultTransformerFactory {
    public static ResultTransformer newInstance(String modeString, Configuration conf) {
        if (StringUtils.isBlank((String)modeString)) {
            return null;
        }
        ResultTransformer.Mode mode = ResultTransformer.Mode.valueOf((String)modeString);
        switch (mode) {
            case compress: {
                final String name = conf.get("index.feed.compress.zip.name");
                return new ResultTransformer(mode){

                    public String apply(String input) {
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        ZipOutputStream zos = new ZipOutputStream(os);
                        ZipEntry entry = new ZipEntry(name);
                        try {
                            zos.putNextEntry(entry);
                            zos.write(input.getBytes());
                            zos.closeEntry();
                            zos.flush();
                            zos.close();
                            return Base64.encodeBase64String((byte[])os.toByteArray());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            case empty: {
                return new ResultTransformer(mode){

                    public String apply(String input) {
                        return "";
                    }
                };
            }
            case xslt: {
                final ApplyXslt xslt = new ApplyXslt(new String(Base64.decodeBase64((String)conf.get("index.feed.result.postprocess.xslt"))));
                return new ResultTransformer(mode){

                    public String apply(String input) {
                        return xslt.evaluate((Object)input);
                    }
                };
            }
        }
        throw new IllegalStateException("shouldn't happen");
    }
}

