/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import com.google.common.base.Function;
import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.transform.OafUtils;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;

public class OafHbaseUtils
extends OafUtils {
    public static OafDecoder decode(ImmutableBytesWritable oaf) {
        return new OafDecoder(oaf.copyBytes());
    }

    public static Function<ImmutableBytesWritable, OafDecoder> decoder() {
        return new Function<ImmutableBytesWritable, OafDecoder>(){

            public OafDecoder apply(ImmutableBytesWritable input) {
                return OafDecoder.decode((byte[])input.copyBytes());
            }
        };
    }

    public static Function<ImmutableBytesWritable, OafProtos.Oaf> oafDecoder() {
        return new Function<ImmutableBytesWritable, OafProtos.Oaf>(){

            public OafProtos.Oaf apply(ImmutableBytesWritable input) {
                return OafHbaseUtils.parse(input);
            }
        };
    }

    public static OafProtos.Oaf parse(ImmutableBytesWritable input) {
        try {
            return OafProtos.Oaf.parseFrom((byte[])input.copyBytes());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

