/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.proto.DedupProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetOafXsltFunctions;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupMarkDeletedEntityMapper
extends TableMapper<ImmutableBytesWritable, Put> {
    private static final Log log = LogFactory.getLog(DedupMarkDeletedEntityMapper.class);
    private static final boolean WRITE_TO_WAL = false;
    private DedupConfig dedupConf;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        log.info((Object)("dedup findRoots mapper\nwf conf: " + this.dedupConf.toString()));
    }

    protected void map(ImmutableBytesWritable rowkey, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = TypeProtos.Type.valueOf((String)this.dedupConf.getWf().getEntityType());
        NavigableMap mergedIn = value.getFamilyMap(DedupUtils.getDedupCF_mergedInBytes(type));
        if (mergedIn != null && !mergedIn.isEmpty()) {
            byte[] row = rowkey.copyBytes();
            this.emitBody(context, row, value.getValue(Bytes.toBytes((String)type.toString()), DedupUtils.BODY_B));
        } else {
            context.getCounter(type.toString(), "row not merged").increment(1L);
        }
    }

    private void emitBody(Mapper.Context context, byte[] row, byte[] body) throws IOException, InterruptedException {
        String type = this.dedupConf.getWf().getEntityType();
        if (body == null) {
            context.getCounter(type, "missing body").increment(1L);
            System.err.println("missing body: " + new String(row));
            return;
        }
        OafProtos.Oaf prototype = OafProtos.Oaf.parseFrom((byte[])body);
        if (prototype.getDataInfo().getDeletedbyinference()) {
            context.getCounter(type, "bodies already deleted").increment(1L);
        } else {
            OafProtos.Oaf.Builder oafRoot = OafProtos.Oaf.newBuilder((OafProtos.Oaf)prototype);
            oafRoot.getDataInfoBuilder().setDeletedbyinference(true).setInferred(true).setInferenceprovenance(this.dedupConf.getWf().getConfigurationId());
            byte[] family = Bytes.toBytes((String)type);
            Put put = new Put(row).add(family, DedupUtils.BODY_B, oafRoot.build().toByteArray());
            put.setWriteToWAL(false);
            context.write((Object)new ImmutableBytesWritable(row), (Object)put);
            context.getCounter(type, "bodies marked deleted").increment(1L);
        }
    }

    private byte[] buildRel(byte[] from, byte[] to, DedupProtos.Dedup.RelName relClass) {
        OafProtos.OafRel.Builder oafRel = DedupUtils.getDedup(this.dedupConf, new String(from), new String(to), relClass);
        OafProtos.Oaf oaf = OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.relation).setTimestamp(System.currentTimeMillis()).setDataInfo(AbstractDNetOafXsltFunctions.getDataInfo(null, (String)"", (String)"0.8", (boolean)false, (boolean)true).setInferenceprovenance(this.dedupConf.getWf().getConfigurationId())).setRel(oafRel).build();
        return oaf.toByteArray();
    }
}

