/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.mapreduce.Mapper;

public class CoAuthorMapper
extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {
    private ImmutableBytesWritable ibw;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.ibw = new ImmutableBytesWritable();
    }

    protected void map(ImmutableBytesWritable keyIn, Result result, Mapper.Context context) throws IOException, InterruptedException {
        OafRowKeyDecoder keyDecoder = OafRowKeyDecoder.decode((byte[])keyIn.copyBytes());
        switch (keyDecoder.getType()) {
            case person: {
                for (KeyValue kv : result.list()) {
                    String cf = new String(kv.getFamily());
                    if (cf.equals(TypeProtos.Type.person.toString()) || cf.equals(TypeProtos.Type.result.toString())) {
                        this.ibw.set(kv.getValue());
                        context.write((Object)keyIn, (Object)this.ibw);
                        continue;
                    }
                    context.getCounter(cf, "skipped family type (map)").increment(1L);
                }
                break;
            }
            default: {
                context.getCounter("coauthor", "skipped entity type (map)").increment(1L);
            }
        }
    }
}

