/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class CalculatePersonDistributionStep2Reducer
extends TableReducer<Text, Text, NullWritable> {
    private static final Log log = LogFactory.getLog(CalculatePersonDistributionStep2Reducer.class);
    private int minPublications = 10;
    private int minPublicationsInRepo = 4;
    private int maxRepos = 10;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.minPublications = NumberUtils.toInt((String)context.getConfiguration().get("MIN_PUBLICATIONS"), (int)10);
        this.minPublicationsInRepo = NumberUtils.toInt((String)context.getConfiguration().get("MIN_PUBLICATIONS_IN_REPO"), (int)4);
        this.maxRepos = NumberUtils.toInt((String)context.getConfiguration().get("MAX_REPOS"), (int)10);
        log.info((Object)String.format("Starting with param minPublications=%s, minPublicationsInRepo=%s, maxRepos=%s", this.minPublications, this.minPublicationsInRepo, this.maxRepos));
    }

    protected void reduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        int total = 0;
        HashMap map = Maps.newHashMap();
        for (Text i : values) {
            String collectedFrom;
            Integer count = (Integer)map.get(collectedFrom = Bytes.toString((byte[])i.copyBytes()));
            map.put(collectedFrom, count == null ? 1 : count + 1);
            ++total;
        }
        if (total >= this.minPublications && map.size() <= this.maxRepos) {
            Integer max = (Integer)Collections.max(map.values());
            if (max >= this.minPublicationsInRepo) {
                int perc = 100 * max / total;
                context.getCounter("Max percentage of results in a repo", StringUtils.leftPad((String)String.valueOf(perc), (int)3, (String)"0") + " %").increment(1L);
            } else {
                context.getCounter("Skipped person", "n pubs in main repo < " + this.minPublicationsInRepo).increment(1L);
            }
        } else if (total < this.minPublications) {
            context.getCounter("Skipped person", "total pubs < " + this.minPublications).increment(1L);
        } else {
            context.getCounter("Skipped person", "n. repos > " + this.maxRepos).increment(1L);
        }
    }
}

