package eu.dnetlib.functionality.index.client;

import java.util.List;

import eu.dnetlib.functionality.index.client.response.BrowseEntry;
import eu.dnetlib.functionality.index.client.response.LookupResponse;

public interface IndexClient {

	LookupResponse lookup(String query, List<String> filterQuery, int from, int to) throws IndexClientException;

	List<BrowseEntry> browse(String query, List<String> browseFields, int max) throws IndexClientException;

	List<BrowseEntry> browse(String query, List<String> browseFields, int max, List<String> filterQuery) throws IndexClientException;

	long delete(String query) throws IndexClientException;

	void stop() throws IndexClientException;

}
