/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.modular.gridFS;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import eu.dnetlib.enabling.resultset.ResultSet;
import eu.dnetlib.enabling.resultset.ResultSetAware;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GridFSObjectstoreResultSetListener
implements ResultSetListener,
ResultSetAware {
    private static final Log log = LogFactory.getLog(GridFSObjectstoreResultSetListener.class);
    private Double fromDate;
    private Double untilDate;
    private List<String> records;
    private String objectStoreID;
    private GridFS collection;
    private String baseURI;
    private int currentSize = -1;
    private DBCursor currentCursor;
    private long cursorPosition;

    public List<String> getResult(int from, int to) {
        if (this.records != null) {
            ArrayList ids = Lists.newArrayList();
            for (int i = from; i < to; ++i) {
                ids.add(this.records.get(i));
            }
            QueryBuilder qBuilder = QueryBuilder.start((String)"metadata.id").in((Object)ids);
            DBObject q = qBuilder.get();
            List out = this.collection.find(q);
            UnaryFunction<String, GridFSDBFile> obtainURL = new UnaryFunction<String, GridFSDBFile>(){

                public String evaluate(GridFSDBFile input) {
                    DBObject metadata = input.getMetaData();
                    ObjectStoreFile newFile = new ObjectStoreFile();
                    newFile.setObjectID((String)metadata.get("id"));
                    newFile.setAccessProtocol(Protocols.HTTP);
                    newFile.setMimeType((String)metadata.get("mime"));
                    log.debug(metadata.get("originalObject"));
                    newFile.setURI(GridFSObjectstoreResultSetListener.this.baseURI + "objectStore=" + GridFSObjectstoreResultSetListener.this.objectStoreID + "&objectId=" + newFile.getObjectID());
                    newFile.setMd5Sum((String)input.get("md5"));
                    return newFile.toJSON();
                }
            };
            return MappedCollection.listMap((Iterable)out, (UnaryFunction)obtainURL);
        }
        if (this.fromDate != null && this.untilDate != null) {
            if (this.currentCursor == null || this.cursorPosition > (long)from) {
                this.createCurrentCursor();
            }
            while (this.cursorPosition < (long)from) {
                this.currentCursor.next();
                ++this.cursorPosition;
            }
            ArrayList<DBObject> out = new ArrayList<DBObject>();
            for (int i = from; i <= to; ++i) {
                if (!this.currentCursor.hasNext()) continue;
                out.add(this.currentCursor.next());
                ++this.cursorPosition;
            }
            UnaryFunction<String, DBObject> obtainURL = new UnaryFunction<String, DBObject>(){

                public String evaluate(DBObject input) {
                    DBObject metadata = (DBObject)input.get("metadata");
                    String orginalFile = (String)metadata.get("originalObject");
                    ObjectStoreFile original = ObjectStoreFile.createObject((String)orginalFile);
                    ObjectStoreFile newFile = new ObjectStoreFile();
                    newFile.setObjectID((String)metadata.get("id"));
                    newFile.setAccessProtocol(Protocols.HTTP);
                    newFile.setMimeType((String)metadata.get("mime"));
                    newFile.setMd5Sum((String)input.get("md5"));
                    if (orginalFile != null) {
                        if (original.getDownloadedURL() == null || original.getDownloadedURL().length() == 0) {
                            newFile.setDownloadedURL(original.getURI());
                        } else {
                            newFile.setDownloadedURL(original.getDownloadedURL());
                        }
                    }
                    try {
                        newFile.setURI(GridFSObjectstoreResultSetListener.this.baseURI + "?objectStore=" + URLEncoder.encode(GridFSObjectstoreResultSetListener.this.objectStoreID, "UTF-8") + "&objectId=" + URLEncoder.encode(newFile.getObjectID(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                    return newFile.toJSON();
                }
            };
            return MappedCollection.listMap(out, (UnaryFunction)obtainURL);
        }
        return null;
    }

    private void createCurrentCursor() {
        BasicDBObject query = new BasicDBObject();
        query.put("$gt", (Object)this.fromDate);
        query.put("$lt", (Object)this.untilDate);
        if (this.currentCursor != null) {
            this.currentCursor.close();
        }
        this.currentCursor = this.collection.getFileList((DBObject)new BasicDBObject("metadata.timestamp", (Object)query)).sort((DBObject)new BasicDBObject("_id", (Object)1));
        this.cursorPosition = 1L;
    }

    public int getSize() {
        if (this.currentSize == -1) {
            this.currentSize = this.calculateSize();
        }
        return this.currentSize - 1;
    }

    private int calculateSize() {
        if (this.records != null) {
            QueryBuilder qBuilder = QueryBuilder.start((String)"metadata.id").in(this.records);
            DBObject q = qBuilder.get();
            List out = this.collection.find(q);
            return out.size();
        }
        if (this.fromDate != null && this.untilDate != null) {
            BasicDBObject query = new BasicDBObject();
            query.put("$gt", (Object)this.fromDate);
            query.put("$lt", (Object)this.untilDate);
            return this.collection.getFileList((DBObject)new BasicDBObject("metadata.timestamp", (Object)query)).size();
        }
        return 0;
    }

    public void setResultSet(ResultSet resultSet) {
        resultSet.close();
    }

    public Double getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Double fromdate) {
        this.fromDate = fromdate;
    }

    public Double getUntilDate() {
        return this.untilDate;
    }

    public void setUntilDate(Double untilDate) {
        this.untilDate = untilDate;
    }

    public List<String> getRecords() {
        return this.records;
    }

    public void setRecords(List<String> records) {
        this.records = records;
    }

    public GridFS getCollection() {
        return this.collection;
    }

    public void setCollection(GridFS collection) {
        this.collection = collection;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getObjectStoreID() {
        return this.objectStoreID;
    }

    public void setObjectStoreID(String objectStoreID) {
        this.objectStoreID = objectStoreID;
    }
}

