/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.modular.gridFS;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import com.mongodb.gridfs.GridFS;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStore;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStoreDao;
import eu.dnetlib.data.objectstore.modular.gridFS.GridFSObjectStore;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.List;
import java.util.regex.Pattern;
import org.bson.BSONObject;
import org.springframework.beans.factory.annotation.Required;

public class GridFSObjectstoreDaoImpl
implements ObjectStoreDao {
    private static final String OBJECTSTOREMETADATANAME = "metadataObjectStore";
    private static final String OBJECTSTOREIDFIELD = "obsId";
    private DB db;
    private boolean upsert;
    private String objectStoreRESTURI;

    public ObjectStore getObjectStore(String obsId) {
        this.db.setWriteConcern(WriteConcern.SAFE);
        obsId = obsId.substring(0, 36);
        GridFSObjectStore objectStore = new GridFSObjectStore(obsId, new GridFS(this.db, obsId), this.isUpsert());
        objectStore.setBaseURI(this.objectStoreRESTURI);
        this.checkIndexes(obsId);
        return objectStore;
    }

    private void checkIndexes(String id) {
        DBCollection coll = this.db.getCollection(id + ".files");
        List indexInfos = coll.getIndexInfo();
        boolean hasTimestampIndex = false;
        for (DBObject info : indexInfos) {
            BSONObject boj = (BSONObject)info.get("key");
            if (boj.get("metadata.timestamp") == null) continue;
            hasTimestampIndex = true;
        }
        if (!hasTimestampIndex) {
            coll.ensureIndex("metadata.timestamp");
        }
    }

    public List<String> listObjectStores() {
        DBCollection metadata = this.db.getCollection(OBJECTSTOREMETADATANAME);
        return MappedCollection.listMap((Iterable)metadata.find(), (UnaryFunction)new UnaryFunction<String, DBObject>(){

            public String evaluate(DBObject object) {
                return (String)object.get(GridFSObjectstoreDaoImpl.OBJECTSTOREIDFIELD);
            }
        });
    }

    public boolean createObjectStore(String obsId, String interpretation) {
        DBCollection coll = this.db.getCollection(OBJECTSTOREMETADATANAME);
        BasicDBObject obj = new BasicDBObject();
        obj.put(OBJECTSTOREIDFIELD, (Object)obsId);
        obj.put("interpretation", (Object)interpretation);
        coll.save((DBObject)obj);
        return true;
    }

    public boolean updateObjectStore(String obsId, String interpretation) {
        DBCollection coll = this.db.getCollection(OBJECTSTOREMETADATANAME);
        BasicDBObject obj = new BasicDBObject();
        obj.put(OBJECTSTOREIDFIELD, (Object)obsId);
        obj.put("interpretation", (Object)interpretation);
        coll.update((DBObject)new BasicDBObject(OBJECTSTOREIDFIELD, (Object)obsId), (DBObject)obj, true, false);
        coll.save((DBObject)obj);
        return true;
    }

    public boolean deleteObjectStore(String obsId) {
        DBCollection coll = this.db.getCollection(OBJECTSTOREMETADATANAME);
        coll.remove((DBObject)new BasicDBObject(OBJECTSTOREIDFIELD, (Object)obsId));
        obsId = obsId.substring(0, 36);
        GridFS objectStore = new GridFS(this.db, obsId);
        Pattern any = Pattern.compile(".");
        BasicDBObject query = new BasicDBObject("md5", (Object)any);
        objectStore.remove((DBObject)query);
        return true;
    }

    public DB getDb() {
        return this.db;
    }

    @Required
    public void setDb(DB db) {
        this.db = db;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    @Required
    public void setUpsert(boolean upsert) {
        this.upsert = upsert;
    }

    public String getObjectStoreRESTURI() {
        return this.objectStoreRESTURI;
    }

    @Required
    public void setObjectStoreRESTURI(String objectStoreRESTURI) {
        this.objectStoreRESTURI = objectStoreRESTURI;
    }
}

