<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"
    xmlns:skos="http://www.w3.org/2004/02/skos/core#"
    xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:tei="http://www.tei-c.org/ns/1.0"
    xmlns="http://www.tei-c.org/ns/1.0" xmlns:f="http://www.filemaker.com/fmpxmlresult"
    exclude-result-prefixes="#all">

    <xsl:template match="bibliography">
        <xsl:variable name="bibitem">
            <xsl:for-each select=".">
                <!--                there should be options here to match AE, CIL, and other corpora as tags via API and to match titles
                
                the current export from zotero has the citation uri but not authors, so matching must be inferred otherwise
                -->

                <xsl:choose>
                    <xsl:when test="contains(.,'CIL')">
                        <xsl:value-of select="substring-before(.,'.')"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>?notcil?</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </xsl:variable>
        <xsl:for-each select=".">
            <xsl:variable name="citekey">
                <!---->

                <xsl:value-of
                    select="document('eaglebib.rdf')
                        [contains(lower-case(.), lower-case($bibitem))]"
                />
            </xsl:variable>
            <xsl:copy>
                <xsl:copy-of select="@*[not(local-name()='ref')]"/>
                <xsl:attribute name="uri">
                    <xsl:value-of
                        select="concat('https://www.zotero.org/groups/eagle_epigraphic_bibliography/items/itemKey/',$citekey)"
                    />
                </xsl:attribute>
                <xsl:value-of select="."/>
            </xsl:copy>
        </xsl:for-each>

    </xsl:template>
</xsl:stylesheet>
