<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="fetchTransformed"/>
	</ARCS>
</NODE>

<NODE name="fetchTransformed" type="FetchMDStoreRecords">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("tran_id")$</PARAM>
		<PARAM required="true" type="string" name="mdFormat" managedBy="system">$params.("tran_format")$</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">tran_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="cleanRecords"/>
	</ARCS>
</NODE>

<NODE name="cleanRecords" type="ApplyXslt">
	<DESCRIPTION>Clean records</DESCRIPTION>
	<PARAMETERS>
<!-- 		<PARAM required="true" type="string" name="xsltClasspath" managedBy="system">/eu/dnetlib/msro/eagle/workflows/xslt/cleaning/uris/popwithvoc.xsl</PARAM> -->
		<PARAM required="true" type="string" name="xsltClasspath" managedBy="system">/eu/dnetlib/msro/eagle/workflows/xslt/cleaning/do-nothing.xsl</PARAM>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">tran_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">cleaned_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="backlinkRecords"/>
	</ARCS>
</NODE>

<NODE name="backlinkRecords" type="TranslationBacklink">
    <DESCRIPTION>Backlink translation records</DESCRIPTION>
    <PARAMETERS>
        <PARAM required="true" type="string" name="inputEprParam" managedBy="system">cleaned_epr</PARAM>
        <PARAM required="true" type="string" name="outputEprParam" managedBy="system">backlined_epr</PARAM>
    </PARAMETERS>
    <ARCS>
        <ARC to="storeRecords"/>
    </ARCS>
</NODE>

<NODE name="storeRecords" type="StoreMDStoreRecords">
	<DESCRIPTION>Store mdtore records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("clean_id")$</PARAM>
		<PARAM required="true" type="string" name="storingType" managedBy="system">REFRESH</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">backlined_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>