package eu.dnetlib.msro.eagle.workflows.nodes.transform.tmid;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class TrismegistosInjectionJobNode extends SimpleJobNode {
	private String inputEprParam;
	private String outputEprParam;
	private String tmIdListPath;

	private MappedResultSetFactory mappedResultSetFactory;
	
	@Override
	protected String execute(NodeToken token) throws Exception {
		final String inputEpr = token.getEnv().getAttribute(inputEprParam);
		if ((inputEpr == null) || inputEpr.isEmpty()) throw new MSROException("InputEprParam (" + inputEprParam + ") not found in ENV");
		final W3CEndpointReference epr = getMappedResultSetFactory().createMappedResultSet(new EPRUtils().getEpr(inputEpr), 
				new TrismegistosInjectionUnaryFunction(tmIdListPath));

		token.getEnv().setAttribute(outputEprParam, epr.toString());

		return Arc.DEFAULT_ARC;
	}
	
	public String getInputEprParam() {
		return inputEprParam;
	}

	public void setInputEprParam(String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public String getTmIdListPath() {
		return tmIdListPath;
	}

	public void setTmIdListPath(String tmIdListPath) {
		this.tmIdListPath = tmIdListPath;
	}

	public MappedResultSetFactory getMappedResultSetFactory() {
		return mappedResultSetFactory;
	}

	public void setMappedResultSetFactory(MappedResultSetFactory mappedResultSetFactory) {
		this.mappedResultSetFactory = mappedResultSetFactory;
	}

}
