package eu.dnetlib.msro.eagle.workflows.nodes.backlink.translations;

import java.io.IOException;

import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;

public class HasTranslationFragment {

	static public String generateFragment(final TranslationInfo translationInfo) {
		String fragmentTemplate;
		try {
			fragmentTemplate =
					IOUtils.toString(HasTranslationFragment.class
							.getResourceAsStream("/eu/dnetlib/msro/eagle/workflows/backlink/translations/hasTranslation.xml.st"));
			StringTemplate st = new StringTemplate(fragmentTemplate);
			st.setAttribute("dnetResourceIdentifier", StringEscapeUtils.escapeXml(translationInfo.getDnetResourceIdentifier()));
			st.setAttribute("providerName", StringEscapeUtils.escapeXml(translationInfo.getProviderName()));
			st.setAttribute("providerAcronym", StringEscapeUtils.escapeXml(translationInfo.getProviderAcronym()));
			st.setAttribute("landingPage", StringEscapeUtils.escapeXml(translationInfo.getLandingPage()));
			st.setAttribute("localId", StringEscapeUtils.escapeXml(translationInfo.getLocalId()));
			st.setAttribute("text", StringEscapeUtils.escapeXml(translationInfo.getText()));
			st.setAttribute("lang", StringEscapeUtils.escapeXml(translationInfo.getLang()));
			return st.toString();
		} catch (IOException e) {
			throw new RuntimeException("HasTranslation template not found!", e);
		}

	}

}
