<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="2.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	extension-element-prefixes="xsl xs fn">

	<xsl:output method="html" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>

	<xsl:template match="/">
		<div class="row">
			<div class="col-xs-2">
				<xsl:variable name="type" select="//*[local-name()='entityType']" /> 
				<xsl:choose>
					<xsl:when test="$type = 'artifact'">
						<img src="../resources/img/eagle/artifact.png" width="80" height="80" />
					</xsl:when>
					<xsl:when test="$type = 'documental'">
						<img src="../resources/img/eagle/doc.png" width="80" height="80" />
					</xsl:when>
					<xsl:when test="$type = 'visual'">
						<img src="../resources/img/eagle/pic.png" width="80" height="80" />
					</xsl:when>
				</xsl:choose>
			</div>
			<div class="col-xs-10">
				<xsl:if test="//*[local-name()='title']">
					<h1 id="overview" ><xsl:value-of select="//*[local-name()='title']" /></h1>
				</xsl:if>
			</div>
		</div>
		
		<div class="row">
			<div class="col-xs-12">
				<h6><span class="glyphicon glyphicon-align-left" /> GENERAL INFORMATION</h6>
				<table class="table">
					<tbody>
						<tr>
							<td class="col-xs-3"><strong>Title</strong></td>
							<td><xsl:value-of select="//*[local-name()='title']" /></td>
						</tr>
						<tr>
							<td class="col-xs-3"><strong>Description</strong></td>
							<td><xsl:value-of select="//*[local-name()='description']" /></td>
						</tr>
						<tr>
							<td class="col-xs-3"><strong>Provided by</strong></td>
							<td><xsl:value-of select="//*[local-name()='eagleObject']/*[local-name()='recordSourceInfo']/@providerName" /></td>
						</tr>
						<tr>
							<td class="col-xs-3"><strong>Landing page</strong></td>
							<td>
								<a href="{//*[local-name()='eagleObject']/*[local-name()='recordSourceInfo']/@landingPage}"><xsl:value-of select="//*[local-name()='eagleObject']/*[local-name()='recordSourceInfo']/@landingPage" /></a>
								&#160;<span class="label label-warning">This HAS to resolve on a valid page!</span>
							</td>
						</tr>
						<tr>
							<td class="col-xs-3"><strong>Local identifier (a.k.a. CP-ID)</strong></td>
							<td>
								<xsl:value-of select="//*[local-name()='eagleObject']/*[local-name()='recordSourceInfo']" />
								&#160;<span class="label label-warning">This MUST be an ID, not an URL!</span>
							</td>
						</tr>
						<tr>
							<td class="col-xs-3"><strong>Last edit</strong></td>
							<td><xsl:value-of select="//*[local-name()='dateEdited']" /></td>
						</tr>
						<tr>
							<td class="col-xs-3"><strong>Edited by</strong></td>
							<td><xsl:value-of select="//*[local-name()='metadataEditor']" /></td>
						</tr>
						<tr>
							<td class="col-xs-3"><strong>Collected on</strong></td>
							<td><xsl:value-of select="//*[local-name()='dateOfCollection']" /></td>
						</tr>
					</tbody>
				</table>
				
				<xsl:variable name="type" select="//*[local-name()='entityType']" /> 
				<xsl:choose>
					<xsl:when test="$type = 'artifact'">
						<h6><span class="glyphicon glyphicon-tower" /> ARTIFACT DETAILS</h6>
						<table class="table">
							<tbody>
								<tr>
									<td class="col-xs-3"><strong>Object type</strong></td>
									<td>
										<xsl:for-each select="//*[local-name()='objectType']">
											<xsl:value-of select="." />
											<xsl:if test="./@uri != ''">
												&#160;<a href="{./@uri}"><span class="glyphicon glyphicon-link"></span></a>
											</xsl:if><br />
										</xsl:for-each>
									</td>
								</tr>
								<tr>
									<td class="col-xs-3"><strong>Material</strong></td>
									<td>
										<xsl:for-each select="//*[local-name()='material']">
											<xsl:value-of select="." />
											<xsl:if test="./@uri != ''">
												&#160;<a href="{./@uri}"><span class="glyphicon glyphicon-link"></span></a>
											</xsl:if><br />
										</xsl:for-each>
									</td>
								</tr>
								<tr>
									<td class="col-xs-3"><strong>Dimensions</strong></td>
									<td>
										<xsl:for-each select="//*[local-name()='dimensions']">
											<xsl:call-template name="threedimensions">
						                        <xsl:with-param name="w" select="./*[local-name()='width']"/>
						                        <xsl:with-param name="h" select="./*[local-name()='height']"/>
						                        <xsl:with-param name="d" select="./*[local-name()='depth']"/>
						                        <xsl:with-param name="unit" select="./@unit"/>
						                    </xsl:call-template><br />
										</xsl:for-each>
				                    </td>
								</tr>
								<tr>
									<td class="col-xs-3"><strong>Decoration</strong></td>
									<td>
										<xsl:value-of select="//*[local-name()='decoration']" />
										<xsl:if test="//*[local-name()='decoration']/@uri != ''">
											&#160;<a href="{//*[local-name()='decoration']/@uri}"><span class="glyphicon glyphicon-link"></span></a>
										</xsl:if>
									</td>
								</tr>
								<tr>
									<td class="col-xs-3"><strong>Places</strong></td>
									<td>
										<table class="table" style="background-color: transparent;">
										<tbody>
											<tr>
												<td class="col-xs-3"><strong>Roman province italic region</strong></td>
												<td>
													<xsl:value-of select="//*[local-name()='romanProvinceItalicRegion']" />
													<xsl:if test="//*[local-name()='romanProvinceItalicRegion']/@uri != ''">
														&#160;<a href="{//*[local-name()='romanProvinceItalicRegion']/@uri}"><span class="glyphicon glyphicon-link"></span></a>
													</xsl:if>
												</td>
											</tr>
											<tr>
												<td class="col-xs-3"><strong>Ancient find spot</strong></td>
												<td>
													<xsl:value-of select="//*[local-name()='ancientFindSpot']" />
													<xsl:if test="//*[local-name()='ancientFindSpot']/@uri != ''">
														&#160;<a href="{//*[local-name()='ancientFindSpot']/@uri}"><span class="glyphicon glyphicon-link"></span></a>
													</xsl:if>
												</td>
											</tr>
											<tr>
												<td class="col-xs-3"><strong>Modern find spot</strong></td>
												<td>
													<xsl:value-of select="//*[local-name()='modernFindSpot']" />
													<xsl:if test="//*[local-name()='modernFindSpot']/@uri != ''">
														&#160;<a href="{//*[local-name()='modernFindSpot']/@uri}"><span class="glyphicon glyphicon-link"></span></a>
													</xsl:if>	
												</td>
											</tr>
											<tr>
												<td class="col-xs-3"><strong>Modern country</strong></td>
												<td>
													<xsl:value-of select="//*[local-name()='modernCountry']" />
													<xsl:if test="//*[local-name()='modernCountry']/@uri != ''">
														&#160;<a href="{//*[local-name()='modernCountry']/@uri}"><span class="glyphicon glyphicon-link"></span></a>
													</xsl:if>
												</td>
											</tr>
											<tr>
												<td class="col-xs-3"><strong>Modern province</strong></td>
												<td>
													<xsl:value-of select="//*[local-name()='modernProvince']" />
													<xsl:if test="//*[local-name()='modernProvince']/@uri != ''">
														&#160;<a href="{//*[local-name()='modernProvince']/@uri}"><span class="glyphicon glyphicon-link"></span></a>
													</xsl:if>
												</td>
											</tr>
											<tr>
												<td class="col-xs-3"><strong>Modern region</strong></td>
												<td>
													<xsl:value-of select="//*[local-name()='modernRegion']" />
													<xsl:if test="//*[local-name()='modernRegion']/@uri != ''">
														&#160;<a href="{//*[local-name()='modernRegion']/@uri}"><span class="glyphicon glyphicon-link"></span></a>
													</xsl:if>
												</td>
											</tr>
										</tbody>
										</table>
									</td>
								</tr>
								<tr>
									<td class="col-xs-3"><strong>Dating</strong></td>
									<td>
										<table class="table" style="background-color: transparent;">
											<tbody>
												<tr>
													<td class="col-xs-3"><strong>Not before</strong></td>
													<td><xsl:value-of select="//*[local-name()='originDating']/@notBefore" /></td>
												</tr>
												<tr>
													<td class="col-xs-3"><strong>Not after</strong></td>
													<td><xsl:value-of select="//*[local-name()='originDating']/@notAfter" /></td>
												</tr>
												<tr>
													<td class="col-xs-3"><strong>Dating provided string</strong></td>
													<td><xsl:value-of select="//*[local-name()='originDating']" /></td>
												</tr>
												<tr>
                                                    <td class="col-xs-3"><strong>Found in</strong></td>
                                                    <td><xsl:value-of select="//*[local-name()='yearOfFinding']" /></td>
                                                </tr>
											</tbody>
										</table>
									</td>
								</tr>
								<tr>
									<td class="col-xs-3"><strong>Conservation</strong></td>
									<td>
										<table class="table" style="background-color: transparent;">
											<tbody>
												<tr>
													<td class="col-xs-3"><strong>State of Conservation</strong></td>
													<td>
														<xsl:value-of select="//*[local-name()='stateOfPreservation']" />
														<xsl:if test="//*[local-name()='stateOfPreservation']/@uri != ''">
															&#160;<a href="{//*[local-name()='stateOfPreservation']/@uri}"><span class="glyphicon glyphicon-link"></span></a>
														</xsl:if>
													</td>
												</tr>
												<tr>
													<td class="col-xs-3"><strong>Conservation country</strong></td>
													<td>
														<xsl:value-of select="//*[local-name()='conservationCountry']" />
														<xsl:if test="//*[local-name()='conservationCountry']/@uri != ''">
															&#160;<a href="{//*[local-name()='conservationCountry']/@uri}"><span class="glyphicon glyphicon-link"></span></a>
														</xsl:if>
													</td>
												</tr>
												<tr>
													<td class="col-xs-3"><strong>Conservation region</strong></td>
													<td>
														<xsl:value-of select="//*[local-name()='conservationRegion']" />
														<xsl:if test="//*[local-name()='conservationRegion']/@uri != ''">
															&#160;<a href="{//*[local-name()='conservationRegion']/@uri}"><span class="glyphicon glyphicon-link"></span></a>
														</xsl:if>
													</td>
												</tr>
												<tr>
													<td class="col-xs-3"><strong>Conservation city</strong></td>
													<td>
														<xsl:value-of select="//*[local-name()='conservationCity']" />
														<xsl:if test="//*[local-name()='conservationCity']/@uri != ''">
															&#160;<a href="{//*[local-name()='conservationCity']/@uri}"><span class="glyphicon glyphicon-link"></span></a>
														</xsl:if>
													</td>
												</tr>
												<tr>
													<td class="col-xs-3"><strong>Museum</strong></td>
													<td><xsl:value-of select="//*[local-name()='museum']" /></td>
												</tr>
												<tr>
													<td class="col-xs-3"><strong>Position</strong></td>
													<td><xsl:value-of select="//*[local-name()='position']" /></td>
												</tr>
												<tr>
													<td class="col-xs-3"><strong>Inventory number</strong></td>
													<td><xsl:value-of select="//*[local-name()='inventoryNumber']" /></td>
												</tr>
											</tbody>
										</table>
									</td>
								</tr>
							</tbody>
						</table>
						
						<xsl:if test="//*[local-name()='inscription']">
							<h6><span class="glyphicon glyphicon-pushpin" /> INSCRIPTION DETAILS</h6>
							<table class="table">
								<tbody>
									<tr>
										<td class="col-xs-3"><strong>Trismegistos Identifier</strong></td>
										<td>
											<xsl:value-of select="//*[local-name()='inscription']//*[local-name()='tmId']" /> &#160;
											<span class="label label-warning">if starting with 'n/a' then a TMid is not available</span>
										</td>
									</tr>
									<tr>
										<td class="col-xs-3"><strong>Other instances</strong></td>
										<td>
											<xsl:for-each select="//*[local-name()='alternateId']">
												<a href="#/doc/dnetresourceidentifier/{.}"><xsl:value-of select="concat(./@localId, ' @ ', ./@providerAcronym)" /></a>
												<br/>
											</xsl:for-each>
										</td>
									</tr>
									<tr>
										<td class="col-xs-3"><strong>Inscription type</strong></td>
										<td>
											<xsl:for-each select="//*[local-name()='inscriptionType']">
												<xsl:value-of select="." />
												<xsl:if test="./@uri != ''">
													&#160;<a href="{./@uri}"><span class="glyphicon glyphicon-link"></span></a>
												</xsl:if><br />
											</xsl:for-each>
										</td>
									</tr>
									<tr>
										<td class="col-xs-3"><strong>Engraving</strong></td>
										<td>
											<xsl:value-of select="//*[local-name()='engravingTechnique']" />
											<xsl:if test="//*[local-name()='engravingTechnique']/@uri != ''">
												&#160;<a href="{//*[local-name()='engravingTechnique']/@uri}"><span class="glyphicon glyphicon-link"></span></a>
											</xsl:if>
										</td>
									</tr>
									<tr>
										<td class="col-xs-3"><strong>Metre</strong></td>
										<td><xsl:value-of select="//*[local-name()='metre']" /></td>
									</tr>
									<tr>
										<td class="col-xs-3"><strong>Paleographic characteristics</strong></td>
										<td><xsl:value-of select="//*[local-name()='paleographicCharacteristics']" /></td>
									</tr>
									<tr>
										<td class="col-xs-3"><strong>Dimensions</strong></td>
										<td>
											<table class="table" style="background-color: transparent;">
												<tbody>
													<tr>
														<td class="col-xs-3"><strong>Field size</strong></td>
														<td>
															<xsl:for-each select="//*[local-name()='fieldSize']">
																<xsl:call-template name="twodimensions">
											                        <xsl:with-param name="w" select="./*[local-name()='width']"/>
											                        <xsl:with-param name="h" select="./*[local-name()='height']"/>
											                        <xsl:with-param name="unit" select="./@unit"/>
											                    </xsl:call-template><br />
															</xsl:for-each>
									                    </td>
													</tr>
													<tr>
														<td class="col-xs-3"><strong>Letter size</strong></td>
														<td>
															<xsl:for-each select="//*[local-name()='letterSize']">
																<xsl:value-of select="concat(., ' ', ./@unit)" /> <br />
															</xsl:for-each>
									                    </td>
													</tr>
												</tbody>
											</table>
										</td>
									</tr>
								</tbody>
							</table>
						</xsl:if>
					</xsl:when>
					<xsl:when test="$type = 'documental'">
						<h6><span class="glyphicon glyphicon-pencil" /> DOCUMENTAL MANIFESTATION DETAILS</h6>
						<table class="table">
							<tbody>
							     <tr>
                                    <td class="col-xs-3"><strong>Document type</strong></td>
                                    <td>
                                        <xsl:value-of select="//*[local-name()='documentType']" />
                                    </td>
                                </tr>
                                <xsl:if test="not(//*[local-name()='translation'])">
									<tr>
										<td class="col-xs-3"><strong>Trismegistos Identifier</strong></td>
										<td>
											<xsl:value-of select="//*[local-name()='tmId']" />&#160;
											<span class="label label-warning">if starting with 'n/a' then a TMid is not available</span>
										</td>
									</tr>
									<tr>
										<td class="col-xs-3"><strong>Other instances</strong></td>
										<td>
											<xsl:for-each select="//*[local-name()='alternateId']">
												<a href="#/doc/dnetresourceidentifier/{.}"><xsl:value-of select="concat(./@localId, ' @ ', ./@providerAcronym)" /></a>
												<br/>
											</xsl:for-each>
										</td>
									</tr>
								</xsl:if>
								<tr>
									<td class="col-xs-3"><strong>Texts</strong></td>
									<td>
										<div class="bs-example bs-example-tabs" role="tabpanel">
											<ul class="nav nav-tabs" role="tablist">
												<li role="presentation" class="active">
													<a data-target="#plain" id="plain-tab" role="tab" data-toggle="tab"
														aria-controls="plain" aria-expanded="true">Plaintext</a>
												</li>
												<xsl:if test="not(//*[local-name()='translation'])">
													<li role="presentation">
														<a data-target="#pretty" role="tab" id="pretty-tab" data-toggle="tab"
															aria-controls="pretty" aria-expanded="false">Pretty Html text</a>
													</li>
													<li role="presentation">
														<a data-target="#html" role="tab" id="html-tab" data-toggle="tab"
															aria-controls="html" aria-expanded="false">Raw Html text</a>
													</li>
													<li role="presentation">
														<a data-target="#epidoc" role="tab" id="epidoc-tab" data-toggle="tab"
															aria-controls="epidoc" aria-expanded="false">Marked up text</a>
													</li>
												</xsl:if>
											</ul>
											<div id="myTabContent" class="tab-content">
												<div role="tabpanel" class="tab-pane fade active in" id="plain"
													aria-labelledby="plain-tab">
													<div>
													    <xsl:if test="//*[local-name()='transcription']">
															<xsl:value-of select="//*[local-name()='transcription']/*[local-name()='text']" />
														</xsl:if>
														<xsl:if test="//*[local-name()='translation']">
													       <xsl:value-of select="//*[local-name()='translation']/*[local-name()='text']" />
														</xsl:if>
													</div>
												</div>
												<xsl:if test="not(//*[local-name()='translation'])">
													<div role="tabpanel" class="tab-pane fade" id="pretty" aria-labelledby="pretty-tab">
														<div>
														    <xsl:choose>
                                                                <xsl:when test="//*[local-name()='textHtml'] = ''"> 
                                                                    This version of text is not present. Did you exported in EpiDoc correctly?
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                    <xsl:for-each select="//*[local-name()='textHtml']">
                                                                        <xsl:copy-of select="//*[local-name()='textHtml']" />
                                                                    </xsl:for-each>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
														</div>
													</div>
													<div role="tabpanel" class="tab-pane fade" id="html" aria-labelledby="html-tab">
														<div>
														    <xsl:choose>
                                                                <xsl:when test="//*[local-name()='textHtml'] = ''"> 
                                                                    This version of text is not present. Did you exported in EpiDoc correctly?
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                    <xsl:for-each select="//*[local-name()='textHtml']">
                                                                        <xsl:call-template name="codeBlock" />
                                                                    </xsl:for-each>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
														</div>
													</div>
													<div role="tabpanel" class="tab-pane fade" id="epidoc" aria-labelledby="epidoc-tab">
														<div>
														    <xsl:choose>
																<xsl:when test="//*[local-name()='textEpidoc'] = ''"> 
																	This version of text is not present. Did you exported in EpiDoc correctly?
																</xsl:when>
																<xsl:otherwise>
																    <xsl:for-each select="//*[local-name()='textEpidoc']">
	                                                                    <xsl:call-template name="codeBlock" />
	                                                                </xsl:for-each>
																</xsl:otherwise>
														    </xsl:choose>
														</div>
													</div>
												</xsl:if>
											</div>
										</div>
									</td>
								</tr>
								<xsl:if test="//*[local-name()='transcription']">
									<tr>
										<td class="col-xs-3"><strong>Critical apparatus</strong></td>
										<td><xsl:value-of select="//*[local-name()='criticalApparatus']" /></td>
									</tr>
									<tr>
										<td class="col-xs-3"><strong>Bibliography</strong></td>
										<td>
											<ul>
												<xsl:for-each select="//*[local-name()='bibliography']">
												  	<li><xsl:value-of select="." /></li>
												</xsl:for-each>
											</ul>
										</td>
									</tr>
									<tr>
										<td class="col-xs-3"><strong>Commentary</strong></td>
										<td><xsl:value-of select="//*[local-name()='commentary']" /></td>
									</tr>
								</xsl:if>
								<xsl:if test="//*[local-name()='translation']">
                                    <tr>
                                        <td class="col-xs-3"><strong>Author</strong></td>
                                        <td><xsl:value-of select="//*[local-name()='author']" /></td>
                                    </tr>
                                    <tr>
                                        <td class="col-xs-3"><strong>Published by</strong></td>
                                        <td><xsl:value-of select="//*[local-name()='publicationEditor']" /></td>
                                    </tr>
                                    <tr>
                                        <td class="col-xs-3"><strong>Publication year</strong></td>
                                        <td><xsl:value-of select="//*[local-name()='publicationYear']" /></td>
                                    </tr>
                                    <tr>
                                        <td class="col-xs-3"><strong>Translation IPR</strong></td>
                                        <td><xsl:value-of select="//*[local-name()='translationIpr']" /></td>
                                    </tr>
								</xsl:if>
							</tbody>
						</table>
					</xsl:when>
					
					<xsl:when test="$type = 'visual'">
						<h6><span class="glyphicon glyphicon-picture" /> VISUAL REPRESENTATION DETAILS</h6>
						<table class="table">
							<tbody>
								<tr>
									<td class="col-xs-3"><strong>Image</strong></td>
									<td>
										<img style="width: 500px;" class="img-thumbnail" src="{//*[local-name()='url']}"/>
									</td>
								</tr>
								<tr>
									<td class="col-xs-3"><strong>IPR statement</strong></td>
									<td><xsl:value-of select="//*[local-name()='visualRepresentationIpr']" /></td>
								</tr>
								<tr>
									<td class="col-xs-3"><strong>IPR statement uri</strong></td>
									<td><xsl:value-of select="//*[local-name()='visualRepresentationIpr']/@uri" /></td>
								</tr>
							</tbody>
						</table>
					</xsl:when>
				</xsl:choose>
			</div>
		</div>
		
		<h6><span class="glyphicon glyphicon-link" /> CONNECTED ENTITIES</h6>
		<table class="table">
			<tbody>
				<xsl:for-each select="//*[local-name()='hasArtifact']">
					<xsl:variable name="linkrel" select="./*[local-name()='dnetResourceIdentifier']" />
					<tr>
						<td class="col-xs-3"><strong>Artifact</strong></td>
						<td><a href="#/doc/dnetresourceidentifier/{$linkrel}"><xsl:value-of select="$linkrel" /></a></td>
					</tr>
				</xsl:for-each>
				<xsl:for-each select="//*[local-name()='hasTranscription']">
					<xsl:variable name="linkrel" select="./*[local-name()='dnetResourceIdentifier']" />
					<tr>
						<td class="col-xs-3"><strong>Transcription</strong></td>
						<td><a href="#/doc/dnetresourceidentifier/{$linkrel}"><xsl:value-of select="$linkrel" /></a></td>
					</tr>
				</xsl:for-each>
				<xsl:for-each select="//*[local-name()='hasTranslation']">
					<xsl:variable name="linkrel" select="./*[local-name()='dnetResourceIdentifier']" />
					<tr>
						<td class="col-xs-3"><strong>Translation</strong></td>
						<td><a href="#/doc/dnetresourceidentifier/{$linkrel}"><xsl:value-of select="$linkrel" /></a></td>
					</tr>
				</xsl:for-each>
				<xsl:if test="//*[local-name()='hasVisualRepresentation']">
					<tr>
						<td class="col-xs-3"><strong>Visual representation</strong></td>
						<td>
							<xsl:for-each select="//*[local-name()='hasVisualRepresentation']">
								<xsl:variable name="linkrel" select="./*[local-name()='dnetResourceIdentifier']" />
								<a href="#/doc/dnetresourceidentifier/{$linkrel}"><img style="width: 200px;" class="img-thumbnail" src="{./*[local-name()='url']}" alt="{$linkrel}"/></a>
							</xsl:for-each>
						</td>
					</tr>
				</xsl:if>
			</tbody>
		</table>
		
		<xsl:for-each select="//*[local-name()='eagleObject']">
			<h6><span class="glyphicon glyphicon-wrench" /> RECORD XML</h6>
			<div style="color:black; font-family:'Courier New', Courier, monospace; font-size:small">
				<xsl:call-template name="xmlItem">
					<xsl:with-param name="indent" select="string('')" />
				</xsl:call-template>
			</div>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="xmlAttr">
		<span style='color:red'><xsl:value-of select="concat(' ', local-name())"/></span>
		<xsl:value-of select="concat('=&quot;', ., '&quot;')"/>
	</xsl:template>
	
	<xsl:template name="xmlItem">
		<xsl:param name="indent" />
		<xsl:variable name="tag" select="local-name()" />
		<xsl:variable name="newindent"><xsl:value-of select="$indent" />&#160;&#160;&#160;&#160;</xsl:variable>

		<xsl:if test="string-length($tag)">
			<br/><xsl:value-of select="$indent" /><span style='color:blue'><xsl:value-of select="concat('&lt;',$tag)" /></span> 
			<xsl:for-each select="@*">
				<xsl:call-template name="xmlAttr"/>
			</xsl:for-each>

			<xsl:choose>
				<xsl:when test="count(child::*) = 0 and count(child::text()) = 1">
					<span style='color:blue'>&gt;</span>
					<xsl:value-of select="normalize-space(.)" />
					<span style='color:blue'><xsl:value-of select="concat('&lt;/',$tag,'&gt;')" /></span>
				</xsl:when>
				<xsl:when test="count(child::* | child::text()) &gt; 0">
					<span style='color:blue'>&gt;</span>
					<xsl:for-each select="child::* | child::text()">
						<xsl:choose>
							<xsl:when test="self::text() and string-length(normalize-space(.)) &gt; 0">
								<xsl:value-of select="normalize-space(.)" />
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="xmlItem">
									<xsl:with-param name="indent" select="$newindent" />
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					<br/><xsl:value-of select="$indent" /><span style='color:blue'><xsl:value-of select="concat('&lt;/',$tag,'&gt;')" /></span>
				</xsl:when>
				<xsl:otherwise>
				 	<span style='color:blue'>&#160;/&gt;</span>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="codeBlock">
		<xsl:variable name="tag" select="local-name()" />
		<xsl:variable name="attribs">
			<xsl:for-each select="@*">
				<xsl:value-of select="concat(' ', local-name(), '=&quot;', ., '&quot;')" />
			</xsl:for-each>
		</xsl:variable>

		<b><xsl:value-of select="concat('&lt;',$tag)" /></b>
		<i><xsl:value-of select="$attribs" /></i>
		<b>&gt;</b>
		<xsl:choose>
			<xsl:when test="count(child::* | text()) &gt; 0">
				<xsl:for-each select="child::* | text()">
					<xsl:choose>
						<xsl:when test="self::text()">
							<xsl:value-of select="." />
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="codeBlock" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
			</xsl:otherwise>
		</xsl:choose>
		<b><xsl:value-of select="concat('&lt;/',$tag,'&gt;')" /></b>
	</xsl:template>
	
    <xsl:template name="threedimensions">
        <xsl:param name="w"/>
        <xsl:param name="h"/>
        <xsl:param name="d"/>
        <xsl:param name="unit"/>
        
        <xsl:variable name="actualW">
            <xsl:choose>
                <xsl:when test="normalize-space($w) != ''">
                    <xsl:value-of select="normalize-space($w)"/>
                </xsl:when>
                <xsl:otherwise>??</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="actualH">
            <xsl:choose>
                <xsl:when test="normalize-space($h) != ''">
                    <xsl:value-of select="normalize-space($h)"/>
                </xsl:when>
                <xsl:otherwise>??</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="actualD">
            <xsl:choose>
                <xsl:when test="normalize-space($d) != ''">
                    <xsl:value-of select="normalize-space($d)"/>
                </xsl:when>
                <xsl:otherwise>??</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:value-of select="concat($actualW,' x ', $actualH,' x ', $actualD, ' (', $unit, ')')"/>
    </xsl:template>
    
    <xsl:template name="twodimensions">
        <xsl:param name="w"/>
        <xsl:param name="h"/>
        <xsl:param name="d"/>
        <xsl:param name="unit"/>
        
        <xsl:variable name="actualW">
            <xsl:choose>
                <xsl:when test="normalize-space($w) != ''">
                    <xsl:value-of select="normalize-space($w)"/>
                </xsl:when>
                <xsl:otherwise>??</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="actualH">
            <xsl:choose>
                <xsl:when test="normalize-space($h) != ''">
                    <xsl:value-of select="normalize-space($h)"/>
                </xsl:when>
                <xsl:otherwise>??</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:value-of select="concat($actualW,' x ', $actualH, ' (', $unit, ')')"/>
    </xsl:template>
	
</xsl:stylesheet>
