<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">

	<xsl:output method="html" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>

	<xsl:template match="/">
		<xsl:variable name="id"   select="//*[local-name() = 'objIdentifier']" />
		<xsl:variable name="type" select="//*[local-name() = 'entityType'   ]" />
		<xsl:variable name="url"  select="//*[local-name() = 'url'          ][1]" />
		
		<div class="well">
			<table>
				<tr>
					<td style="width: 120px">
						<xsl:choose>
							<xsl:when test="$type = 'artifact'">
								<img src="../resources/img/eagle/artifact.png" width="80" height="80" />
							</xsl:when>
							<xsl:when test="$type = 'documental'">
								<img src="../resources/img/eagle/doc.png" width="80" height="80" />
							</xsl:when>
							<xsl:when test="$type = 'visual'">
								<img src="../resources/img/eagle/pic.png" width="80" height="80" />
							</xsl:when>
						</xsl:choose>
					</td>
					<td>
						<strong>Title: </strong><xsl:value-of select="//*[local-name()='title']" /><br/>			
						<strong>Entity type: </strong><xsl:value-of select="$type" /><br/>	
						<strong>Description: </strong><i><xsl:value-of select="//*[local-name()='description']" /></i><br/>
						<xsl:if test="$url and $type = 'visual'">
							<br/><b>Image at: </b>
							<a href="{$url}"><xsl:value-of select="$url" /></a><br />
						</xsl:if>
						<br />
						<button class="btn btn-primary btn-sm" ng-click="getDocument('objidentifier', '{$id}')">show record</button>
					</td>
				</tr>
			</table>
		</div>
	</xsl:template>
	
</xsl:stylesheet>