/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.download;

import eu.dnetlib.data.download.DownloadReportMap;
import eu.dnetlib.data.download.rmi.DownloadServiceActions;
import eu.dnetlib.data.download.rmi.DownloadServiceException;
import eu.dnetlib.data.download.rmi.DownloadServiceFeeder;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadAction
implements BlackboardServerAction<DownloadServiceActions> {
    private static final Log log = LogFactory.getLog(DownloadAction.class);
    @Resource
    DownloadServiceFeeder downloadServiceFeeder;
    private static String DEFAULT_NUMBER_OF_THREAD = "5";

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception {
        try {
            String epr = (String)job.getParameters().get("epr");
            String plugin = (String)job.getParameters().get("plugin");
            String objectStoreID = (String)job.getParameters().get("objectStoreID");
            String protocol = (String)job.getParameters().get("protocol");
            String mimeType = (String)job.getParameters().get("mimeType");
            String numberOfThreads = (String)job.getParameters().get("thread");
            String basePath = (String)job.getParameters().get("basePath");
            if (numberOfThreads == "" || numberOfThreads == null) {
                log.warn((Object)("Cannot find numberOfThread, using default value " + DEFAULT_NUMBER_OF_THREAD));
                numberOfThreads = DEFAULT_NUMBER_OF_THREAD;
            }
            log.info((Object)String.format("downloading using plugin %s , protocol : %s into ObjectStore id %s  ", plugin, protocol, objectStoreID));
            handler.ongoing(job);
            DownloadReportMap response = this.downloadServiceFeeder.download(epr, plugin, objectStoreID, protocol, mimeType, Integer.parseInt(numberOfThreads), basePath);
            job.getParameters().put("downloadReport", "" + response.getTotalDownloaded());
            if (response.getStatus()) {
                log.info((Object)String.format("Completed Download", plugin, protocol, objectStoreID));
                handler.done(job);
            } else {
                log.error((Object)("response is false" + response));
                handler.failed(job, (Throwable)new DownloadServiceException("Opps something bad happen to our download hamsters" + response.toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            handler.failed(job, (Throwable)new DownloadServiceException((Throwable)e));
        }
    }
}

