/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.download.rmi;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import eu.dnetlib.data.download.DownloadPluginEnumeratorImpl;
import eu.dnetlib.data.download.DownloadReport;
import eu.dnetlib.data.download.DownloadReportMap;
import eu.dnetlib.data.download.DownloadServiceImpl;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadServiceException;
import eu.dnetlib.data.download.worker.DownloadWorker;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStore;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStoreDao;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DownloadServiceFeeder {
    private static final Log log = LogFactory.getLog(DownloadServiceFeeder.class);
    @Resource
    DownloadPluginEnumeratorImpl downloadPluginEnumerator;
    @Resource
    private ResultSetClientFactory resultSetClientFactory;
    @Autowired
    private ObjectStoreDao objectStoreDao;

    public DownloadReportMap download(String epr, String plugin, String objectStoreID, String protocol, String mimeType, int numberOfThreads, String basePath, List<String> regularExpression) throws DownloadServiceException, ObjectStoreServiceException {
        int i;
        final DownloadPlugin downloadPlugin = this.downloadPluginEnumerator.get(plugin);
        if (basePath != null && !basePath.isEmpty()) {
            downloadPlugin.setBasePath(basePath);
        }
        IterableResultSetClient urlInfo = this.resultSetClientFactory.getClient(epr);
        ArrayBlockingQueue<String> itemsQueue = new ArrayBlockingQueue<String>(1024);
        ExecutorService executor = Executors.newFixedThreadPool(numberOfThreads);
        ObjectStore objStore = this.objectStoreDao.getObjectStore(objectStoreID);
        ArrayList responses = Lists.newArrayList();
        if (regularExpression != null) {
            downloadPlugin.setRegularExpression(regularExpression);
        }
        for (i = 0; i < numberOfThreads; ++i) {
            responses.add(executor.submit(new DownloadWorker(itemsQueue, objStore, Protocols.valueOf((String)protocol), mimeType, new Function<String, DownloadItem>(){

                public DownloadItem apply(String input) {
                    if (input == null) {
                        log.error((Object)"Input is null");
                        return null;
                    }
                    if (input.equals("END_DOWNLOAD")) {
                        return DownloadServiceImpl.END_QUEUE;
                    }
                    try {
                        DownloadItem di = DownloadItem.newObjectfromJSON((String)input);
                        if (downloadPlugin.retrieveUrl(di) == null) {
                            di.setUrl(null);
                            di.setOriginalUrl(null);
                        }
                        return di;
                    }
                    catch (Throwable e) {
                        log.error((Object)("Exception on trasform item :" + input), e);
                        return null;
                    }
                }
            })));
        }
        i = 0;
        if (urlInfo != null) {
            for (String downloadItem : urlInfo) {
                if (downloadItem == null) continue;
                if (i++ % 1000 == 0) {
                    log.debug((Object)("Read " + i));
                }
                try {
                    itemsQueue.put(downloadItem);
                }
                catch (Exception e) {
                    log.error((Object)("An error occurred while populating the download items queue: " + Joiner.on((String)"\tat ").join((Object[])e.getStackTrace())));
                }
            }
        }
        try {
            itemsQueue.put("END_DOWNLOAD");
        }
        catch (InterruptedException e) {
            log.error((Object)("An error occurred adding the loop terminator: " + Joiner.on((String)"\tat ").join((Object[])e.getStackTrace())));
        }
        DownloadReportMap resultMap = new DownloadReportMap();
        resultMap.setStatus(true);
        for (Future currentResponses : responses) {
            try {
                DownloadReportMap currentMap = (DownloadReportMap)currentResponses.get();
                for (String key : currentMap.keySet()) {
                    if (!resultMap.containsKey(key)) {
                        resultMap.put(key, currentMap.get(key));
                        resultMap.setTotalDownloaded(currentMap.getTotalDownloaded());
                        resultMap.setStatus(currentMap.getStatus());
                        continue;
                    }
                    DownloadReport currentReport = (DownloadReport)currentMap.get(key);
                    ((DownloadReport)resultMap.get(key)).incrementError(currentReport.getNumberOfOccurrences());
                }
                log.info((Object)("Status " + currentMap.getStatus()));
                resultMap.setStatus(resultMap.getStatus() && currentMap.getStatus());
                resultMap.setTotalDownloaded(currentMap.getTotalDownloaded() + resultMap.getTotalDownloaded());
            }
            catch (Exception e) {
                log.error((Object)e);
                resultMap.setStatus(false);
            }
        }
        executor.shutdown();
        return resultMap;
    }
}

