/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.download;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.data.download.DownloadReportMap;
import eu.dnetlib.data.download.rmi.DownloadServiceActions;
import eu.dnetlib.data.download.rmi.DownloadServiceException;
import eu.dnetlib.data.download.rmi.DownloadServiceFeeder;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadAction
implements BlackboardServerAction<DownloadServiceActions> {
    private static final Log log = LogFactory.getLog(DownloadAction.class);
    @Resource
    private DownloadServiceFeeder downloadServiceFeeder;
    private static String DEFAULT_NUMBER_OF_THREAD = "5";

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception {
        try {
            String epr = (String)job.getParameters().get("epr");
            String plugin = (String)job.getParameters().get("plugin");
            String objectStoreID = (String)job.getParameters().get("objectStoreID");
            String protocol = (String)job.getParameters().get("protocol");
            String mimeType = (String)job.getParameters().get("mimeType");
            String numberOfThreads = (String)job.getParameters().get("thread");
            String basePath = (String)job.getParameters().get("basePath");
            String regularExpression = (String)job.getParameters().get("regularExpressions");
            log.debug((Object)("regular Expression: " + regularExpression));
            List<String> expressions = null;
            if (!StringUtils.isBlank((String)regularExpression)) {
                expressions = this.parseRegexList(regularExpression);
            }
            if (StringUtils.isBlank((String)numberOfThreads)) {
                log.warn((Object)("Cannot find numberOfThread, using default value " + DEFAULT_NUMBER_OF_THREAD));
                numberOfThreads = DEFAULT_NUMBER_OF_THREAD;
            }
            log.info((Object)String.format("downloading using plugin %s , protocol : %s into ObjectStore id %s  ", plugin, protocol, objectStoreID));
            handler.ongoing(job);
            DownloadReportMap response = this.downloadServiceFeeder.download(epr, plugin, objectStoreID, protocol, mimeType, Integer.parseInt(numberOfThreads), basePath, expressions);
            if (response.getStatus()) {
                log.info((Object)String.format("Completed Download, plugin: %s, protocol: %s, objectStoreID: %s", plugin, protocol, objectStoreID));
                job.getParameters().put("total", "" + response.getTotalDownloaded());
                handler.done(job);
            } else {
                log.error((Object)("download response is false" + response));
                handler.failed(job, (Throwable)new DownloadServiceException("oops! something bad happen to our download hamsters, response: " + response.toString()));
            }
        }
        catch (Exception e) {
            log.error((Object)"An error occur while starting download", (Throwable)e);
            handler.failed(job, (Throwable)new DownloadServiceException((Throwable)e));
        }
    }

    private List<String> parseRegexList(String regularExpression) {
        log.info((Object)("parsing regex list: " + regularExpression));
        return (List)new Gson().fromJson(regularExpression, new TypeToken<List<String>>(){}.getType());
    }
}

