package eu.dnetlib.data.download.rmi;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;

/**
 * The Class DownloadServiceImpl.
 */
public class DownloadServiceImpl extends AbstractBaseService implements DownloadService {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(DownloadServiceImpl.class);

	/** The Constant END_QUEUE. */
	public static final DownloadItem END_QUEUE = new DownloadItem();

    public static final String  END_QUEUE_STRING ="END_DOWNLOAD";

	@Resource
	private DownloadServiceFeeder downloadfeeder;

	/** The download plugin enumerator. */
	@Resource
	DownloadPluginEnumeratorImpl downloadPluginEnumerator;

	/** The notification handler. */
	private NotificationHandler notificationHandler;

	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.data.download.rmi.DownloadService#downloadFromResultSet(javax.xml.ws.wsaddressing.W3CEndpointReference,
	 * java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public void downloadFromResultSet(final W3CEndpointReference resultSet,
			final String plugin,
			final String objectStoreID,
			final String protocol,
			final String mimeType) throws DownloadServiceException {
		new String();

		log.info(String.format("Try to download using plugin %s , protocol : %s into ObjectStore id %s  ", plugin, protocol, objectStoreID));
		downloadfeeder.download(resultSet.toString(), plugin, objectStoreID, protocol, mimeType, 5);
		log.info(String.format("Completed Download", plugin, protocol, objectStoreID));
	}

	/**
	 * {@inheritDoc}
	 *
	 * @see eu.dnetlib.enabling.tools.AbstractBaseService#notify(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public void notify(final String subscriptionId, final String topic, final String isId, final String message) {
		getNotificationHandler().notified(subscriptionId, topic, isId, message);
	}

	/**
	 * @return the downloadfeeder
	 */
	public DownloadServiceFeeder getDownloadfeeder() {
		return downloadfeeder;
	}

	/**
	 * @param downloadfeeder
	 *            the downloadfeeder to set
	 */
	public void setDownloadfeeder(final DownloadServiceFeeder downloadfeeder) {
		this.downloadfeeder = downloadfeeder;
	}

	/**
	 * @return the notificationHandler
	 */
	public NotificationHandler getNotificationHandler() {
		return notificationHandler;
	}

	/**
	 * @param notificationHandler
	 *            the notificationHandler to set
	 */
	@Required
	public void setNotificationHandler(final NotificationHandler notificationHandler) {
		this.notificationHandler = notificationHandler;
	}

	@Override
	public List<String> listPlugins() throws DownloadServiceException {

		List<String> result = new ArrayList<String>();
		result.addAll(downloadPluginEnumerator.getAll().keySet());
		return result;
	}

}
