package eu.dnetlib.data.download.rmi;

import javax.annotation.Resource;

import eu.dnetlib.data.download.DownloadReportMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class DownloadAction implements BlackboardServerAction<DownloadServiceActions> {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(DownloadAction.class);

	@Resource
	DownloadServiceFeeder downloadServiceFeeder;

	private static String DEFAULT_NUMBER_OF_THREAD = "5";

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {


		String epr = job.getParameters().get("epr");
		String plugin = job.getParameters().get("plugin");
		String objectStoreID = job.getParameters().get("objectStoreID");
		String protocol = job.getParameters().get("protocol");
		String mimeType = job.getParameters().get("mimeType");
		String numberOfThreads = job.getParameters().get("thread");
		if ((numberOfThreads == "") || (numberOfThreads == null)) {
			log.warn("Cannot find numberOfThread, using default value " + DEFAULT_NUMBER_OF_THREAD);
			numberOfThreads = DEFAULT_NUMBER_OF_THREAD;
		}
		log.info(String.format("downloading using plugin %s , protocol : %s into ObjectStore id %s  ", plugin, protocol, objectStoreID));
		handler.ongoing(job);
		DownloadReportMap response = downloadServiceFeeder.download(epr, plugin, objectStoreID, protocol, mimeType, Integer.parseInt(numberOfThreads));
        job.getParameters().put("downloadReport", response.toString());
		if (response.getStatus()) {
			log.info(String.format("Completed Download", plugin, protocol, objectStoreID));
			handler.done(job);
		} else {
			handler.failed(job, new DownloadServiceException("Opps something bad happen to our download hamsters"));
		}
	}

}
