/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.download.worker;

import com.google.common.base.Function;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadServiceImpl;
import eu.dnetlib.data.objectstore.modular.ObjectStoreRecord;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStore;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadWorker
implements Callable<Boolean> {
    private static final Log log = LogFactory.getLog(DownloadWorker.class);
    private BlockingQueue<String> queue = null;
    private ObjectStore objectStore = null;
    private Protocols protocol;
    private String mimeType;
    private Function<String, DownloadItem> converter;

    public DownloadWorker(BlockingQueue<String> queue, ObjectStore objectStore, Protocols protocol, String mimeType, Function<String, DownloadItem> converter) {
        this.setConverter(converter);
        this.setQueue(queue);
        this.setObjectStore(objectStore);
        this.setMimeType(mimeType);
        this.setProtocol(protocol);
    }

    @Override
    public Boolean call() throws Exception {
        try {
            DownloadItem di = (DownloadItem)this.getConverter().apply((Object)this.queue.take());
            while (di != DownloadServiceImpl.END_QUEUE) {
                if (di.getUrl() != null && di.getUrl().length() != 0 && !this.checkIfExists(di)) {
                    try {
                        URL toDownload = this.followURL(new URL(di.getUrl()));
                        if (toDownload == null) continue;
                        ObjectStoreRecord record = new ObjectStoreRecord();
                        ObjectStoreFile metadata = new ObjectStoreFile();
                        metadata.setObjectID(di.getFileName());
                        metadata.setMetadataRelatedID(di.getIdItemMetadata());
                        metadata.setAccessProtocol(this.protocol);
                        metadata.setMimeType(this.mimeType);
                        metadata.setDownloadedURL(di.getOriginalUrl());
                        record.setFileMetadata(metadata);
                        record.setInputStream(toDownload.openStream());
                        this.objectStore.feedObjectRecord(record);
                        log.debug((Object)("Saved object " + metadata.toJSON()));
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
                di = (DownloadItem)this.getConverter().apply((Object)this.queue.take());
            }
            this.queue.put("END_DOWNLOAD");
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
        log.info((Object)"CLOSED THREAD");
        return true;
    }

    private URL followURL(URL inputURL) {
        URL startURL = inputURL;
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)startURL.openConnection();
            conn.setInstanceFollowRedirects(true);
            HttpURLConnection.setFollowRedirects(true);
            String location = inputURL.toString();
            if (conn.getResponseCode() >= 300 && conn.getResponseCode() < 400) {
                location = conn.getHeaderFields().get("Location").get(0);
                conn.disconnect();
            }
            if (location != inputURL.toString()) {
                return new URL(location);
            }
            return inputURL;
        }
        catch (IOException e) {
            log.error((Object)"Error on follow URL ", (Throwable)e);
            return null;
        }
    }

    private boolean checkIfExists(DownloadItem di) {
        try {
            return this.objectStore.deliverObject(di.getFileName()) != null;
        }
        catch (ObjectStoreServiceException e) {
            return false;
        }
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(ObjectStore objectStore) {
        this.objectStore = objectStore;
    }

    public BlockingQueue<String> getQueue() {
        return this.queue;
    }

    public void setQueue(BlockingQueue<String> queue) {
        this.queue = queue;
    }

    public Protocols getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocols protocol) {
        this.protocol = protocol;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public Function<String, DownloadItem> getConverter() {
        return this.converter;
    }

    public void setConverter(Function<String, DownloadItem> converter) {
        this.converter = converter;
    }
}

