/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.download.rmi;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadPluginEnumeratorImpl;
import eu.dnetlib.data.download.rmi.DownloadServiceException;
import eu.dnetlib.data.download.rmi.DownloadServiceImpl;
import eu.dnetlib.data.download.worker.DownloadWorker;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStore;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStoreDao;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DownloadServiceFeeder {
    private static final Log log = LogFactory.getLog(DownloadServiceFeeder.class);
    @Resource
    DownloadPluginEnumeratorImpl downloadPluginEnumerator;
    @Resource
    private ResultSetClientFactory resultSetClientFactory;
    @Autowired
    private ObjectStoreDao objectStoreDao;

    public boolean download(String epr, String plugin, String objectStoreID, String protocol, String mimeType, int numberOfThreads) throws DownloadServiceException {
        final DownloadPlugin downloadPlugin = this.downloadPluginEnumerator.get(plugin);
        IterableResultSetClient urlInfo = this.resultSetClientFactory.getClient(epr);
        ArrayBlockingQueue<String> itemsQueue = new ArrayBlockingQueue<String>(1024);
        ExecutorService executor = Executors.newFixedThreadPool(numberOfThreads);
        ObjectStore objStore = this.objectStoreDao.getObjectStore(objectStoreID);
        ArrayList responses = Lists.newArrayList();
        for (int i = 0; i < numberOfThreads; ++i) {
            responses.add(executor.submit(new DownloadWorker(itemsQueue, objStore, Protocols.valueOf((String)protocol), mimeType, new Function<String, DownloadItem>(){

                public DownloadItem apply(String input) {
                    if (input.equals("END_DOWNLOAD")) {
                        return DownloadServiceImpl.END_QUEUE;
                    }
                    DownloadItem di = DownloadItem.newObjectfromJSON((String)input);
                    if (downloadPlugin.retrieveUrl(di) == null) {
                        di.setUrl(null);
                        di.setOriginalUrl(null);
                    }
                    return di;
                }
            })));
        }
        for (String di : urlInfo) {
            try {
                itemsQueue.put(di);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
        }
        try {
            itemsQueue.put("END_DOWNLOAD");
        }
        catch (InterruptedException e) {
            log.error((Object)e);
        }
        return Iterables.all((Iterable)responses, (Predicate)new Predicate<Future<Boolean>>(){

            public boolean apply(Future<Boolean> input) {
                try {
                    return input.get();
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
    }
}

