/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.download.worker;

import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadServiceImpl;
import eu.dnetlib.data.objectstore.modular.ObjectStoreRecord;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStore;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import java.net.URL;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(DownloadWorker.class);
    private BlockingQueue<DownloadItem> queue = null;
    private ObjectStore objectStore = null;
    private Protocols protocol;
    private String mimeType;

    public DownloadWorker(BlockingQueue<DownloadItem> queue, ObjectStore objectStore, Protocols protocol, String mimeType) {
        this.setQueue(queue);
        this.setObjectStore(objectStore);
        this.setMimeType(mimeType);
        this.setProtocol(protocol);
    }

    @Override
    public void run() {
        try {
            DownloadItem di = this.queue.take();
            while (di != DownloadServiceImpl.END_QUEUE) {
                if (di.getUrl() != null && di.getUrl().length() != 0 && this.checkIfExists(di)) {
                    try {
                        URL toDownload = new URL(di.getUrl());
                        ObjectStoreRecord record = new ObjectStoreRecord();
                        ObjectStoreFile metadata = new ObjectStoreFile();
                        metadata.setObjectID(di.getFileName());
                        metadata.setMetadataRelatedID(di.getIdItemMetadata());
                        metadata.setAccessProtocol(this.protocol);
                        metadata.setMimeType(this.mimeType);
                        metadata.setDownloadedURL(di.getOriginalUrl());
                        record.setFileMetadata(metadata);
                        record.setInputStream(toDownload.openStream());
                        this.objectStore.feedObjectRecord(record);
                        log.debug((Object)("Saved object " + metadata.toJSON()));
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
                di = this.queue.take();
            }
            this.queue.put(DownloadServiceImpl.END_QUEUE);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        log.info((Object)"CLOSED THREAD");
    }

    private boolean checkIfExists(DownloadItem di) {
        try {
            return this.objectStore.deliverObject(di.getFileName()) != null;
        }
        catch (ObjectStoreServiceException e) {
            return false;
        }
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(ObjectStore objectStore) {
        this.objectStore = objectStore;
    }

    public BlockingQueue<DownloadItem> getQueue() {
        return this.queue;
    }

    public void setQueue(BlockingQueue<DownloadItem> queue) {
        this.queue = queue;
    }

    public Protocols getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocols protocol) {
        this.protocol = protocol;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

